/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.bluemodern.FillRoundShape;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernDivider
extends AbstractTextualComponent {
    private final HtmlColor background1;
    private final HtmlColor background2;
    private final HtmlColor borderColor;

    public ComponentBlueModernDivider(HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl, UFont uFont, HtmlColor htmlColor3, HtmlColor htmlColor4, HtmlColor htmlColor5, Display display, ISkinSimple iSkinSimple) {
        super(display, htmlColor, htmlColor2, bl, uFont, HorizontalAlignment.CENTER, 4, 4, 4, iSkinSimple, 0.0, false);
        this.background1 = htmlColor3;
        this.background2 = htmlColor4;
        this.borderColor = htmlColor5;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextWidth(stringBounder);
        double d2 = this.getTextHeight(stringBounder);
        double d3 = (dimension2D.getWidth() - d - 6.0) / 2.0;
        double d4 = (dimension2D.getHeight() - d2) / 2.0;
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.BLACK));
        uGraphic = uGraphic.apply(new UStroke(2.0));
        uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() / 2.0 - 1.0)).draw(new ULine(dimension2D.getWidth(), 0.0));
        uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() / 2.0 + 2.0)).draw(new ULine(dimension2D.getWidth(), 0.0));
        FillRoundShape fillRoundShape = new FillRoundShape(d + 6.0, d2, this.background1, this.background2, 5.0);
        fillRoundShape.drawU(uGraphic.apply(new UTranslate(d3, d4)));
        uGraphic = uGraphic.apply(new UChangeColor(this.borderColor));
        uGraphic = uGraphic.apply(new UChangeBackColor(null));
        uGraphic.apply(new UTranslate(d3, d4)).draw(new URectangle(d + 6.0, d2, 5.0, 5.0));
        uGraphic = uGraphic.apply(new UStroke());
        textBlock.drawU(uGraphic.apply(new UTranslate(d3 + 6.0, d4 + (double)this.getMarginY())));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

