/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseDivider
extends AbstractTextualComponent {
    private final HtmlColor background;
    private final boolean empty;
    private final boolean withShadow;
    private final UStroke stroke;

    public ComponentRoseDivider(HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl, UFont uFont, HtmlColor htmlColor3, Display display, ISkinSimple iSkinSimple, boolean bl2, UStroke uStroke) {
        super(display, htmlColor, htmlColor2, bl, uFont, HorizontalAlignment.CENTER, 4, 4, 4, iSkinSimple, 0.0, false);
        this.background = htmlColor3;
        this.empty = display.get(0).length() == 0;
        this.withShadow = bl2;
        this.stroke = uStroke;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic = uGraphic.apply(new UChangeBackColor(this.background));
        if (this.empty) {
            this.drawSep(uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() / 2.0)), dimension2D.getWidth());
        } else {
            TextBlock textBlock = this.getTextBlock();
            StringBounder stringBounder = uGraphic.getStringBounder();
            double d = this.getTextWidth(stringBounder);
            double d2 = this.getTextHeight(stringBounder);
            double d3 = (dimension2D.getWidth() - d - 6.0) / 2.0;
            double d4 = (dimension2D.getHeight() - d2) / 2.0;
            this.drawSep(uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() / 2.0)), dimension2D.getWidth());
            uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
            uGraphic = uGraphic.apply(this.stroke);
            URectangle uRectangle = new URectangle(d + 6.0, d2);
            if (this.withShadow) {
                uRectangle.setDeltaShadow(4.0);
            }
            uGraphic.apply(new UTranslate(d3, d4)).draw(uRectangle);
            textBlock.drawU(uGraphic.apply(new UTranslate(d3 + 6.0, d4 + (double)this.getMarginY())));
        }
    }

    private void drawSep(UGraphic uGraphic, double d) {
        uGraphic = uGraphic.apply(new UChangeColor(this.background));
        this.drawRectLong(uGraphic.apply(new UTranslate(0.0, -1.0)), d);
        this.drawDoubleLine(uGraphic, d);
    }

    private void drawRectLong(UGraphic uGraphic, double d) {
        URectangle uRectangle = new URectangle(d, 3.0);
        if (this.withShadow) {
            uRectangle.setDeltaShadow(2.0);
        }
        uGraphic = uGraphic.apply(new UStroke());
        uGraphic.draw(uRectangle);
    }

    private void drawDoubleLine(UGraphic uGraphic, double d) {
        uGraphic = uGraphic.apply(new UStroke(this.stroke.getThickness() / 2.0)).apply(new UChangeColor(HtmlColorUtils.BLACK));
        ULine uLine = new ULine(d, 0.0);
        uGraphic.apply(new UTranslate(0.0, -1.0)).draw(uLine);
        uGraphic.apply(new UTranslate(0.0, 2.0)).draw(uLine);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

