/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class EntityImageEmptyPackage2
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final HtmlColor specificBackColor;
    private final ISkinParam skinParam;
    private final Stereotype stereotype;

    public EntityImageEmptyPackage2(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        this.skinParam = iSkinParam;
        this.specificBackColor = iLeaf.getSpecificBackColor();
        this.stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.PACKAGE, this.stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.PACKAGE, this.stereotype), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, iSkinParam);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0, 20.0 + dimension2D.getHeight() * 2.0);
    }

    public final void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        HtmlColor htmlColor = Cluster.getStateBackColor(this.specificBackColor, this.skinParam, this.stereotype);
        ClusterDecoration clusterDecoration = new ClusterDecoration(this.getSkinParam().getPackageStyle(), null, this.desc, TextBlockUtils.empty(0.0, 0.0), htmlColor, 0.0, 0.0, d, d2);
        clusterDecoration.drawU(uGraphic, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.packageBorder, this.getStereo()), this.getSkinParam().shadowing());
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

