/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageStateBorder
extends AbstractEntityImage {
    public static final double RADIUS = 6.0;
    private final TextBlock desc;
    private final Cluster stateParent;
    private final EntityPosition entityPosition;
    private final Bibliotekon bibliotekon;

    public EntityImageStateBorder(ILeaf iLeaf, ISkinParam iSkinParam, Cluster cluster, Bibliotekon bibliotekon) {
        super(iLeaf, iSkinParam);
        this.bibliotekon = bibliotekon;
        this.entityPosition = iLeaf.getEntityPosition();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
        this.stateParent = cluster;
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.STATE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.STATE, stereotype), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, iSkinParam);
    }

    private boolean upPosition() {
        Point2D point2D = this.stateParent.getClusterPosition().getPointCenter();
        Shape shape = this.bibliotekon.getShape(this.getEntity());
        return shape.getMinY() < point2D.getY();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(12.0, 12.0);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        return dimension2D.getWidth();
    }

    public final void drawU(UGraphic uGraphic) {
        UEllipse uEllipse = new UEllipse(12.0, 12.0);
        double d = 0.0;
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d2 = 0.0 - (dimension2D.getWidth() - 12.0) / 2.0;
        d = this.upPosition() ? (d -= 12.0 + dimension2D.getHeight()) : (d += 12.0);
        this.desc.drawU(uGraphic.apply(new UTranslate(d2, d)));
        uGraphic = uGraphic.apply(new UStroke(1.5)).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo())));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        uGraphic.draw(uEllipse);
        if (this.entityPosition == EntityPosition.EXIT_POINT) {
            EntityImageStateBorder.drawLine(uGraphic, this.getPointOnCircle(6.5, 6.5, 0.7853981633974483, 5.5), this.getPointOnCircle(6.5, 6.5, 3.9269908169872414, 5.5));
            EntityImageStateBorder.drawLine(uGraphic, this.getPointOnCircle(6.5, 6.5, -0.7853981633974483, 5.5), this.getPointOnCircle(6.5, 6.5, 2.356194490192345, 5.5));
        }
    }

    private Point2D getPointOnCircle(double d, double d2, double d3, double d4) {
        double d5 = d + d4 * Math.cos(d3);
        double d6 = d2 + d4 * Math.sin(d3);
        return new Point2D.Double(d5, d6);
    }

    private static void drawLine(UGraphic uGraphic, Point2D point2D, Point2D point2D2) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        uGraphic.apply(new UTranslate(point2D.getX(), point2D.getY())).draw(new ULine(d, d2));
    }

    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    public int getShield() {
        return 0;
    }
}

