/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.turing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.turing.BFMachine;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemTuring
extends AbstractPSystem {
    private final String program;
    private final String input;

    PSystemTuring(String string, String string2) {
        this.program = string;
        this.input = string2;
    }

    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        GraphicStrings graphicStrings = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, graphicStrings.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null);
        imageBuilder.addUDrawable(graphicStrings);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption.getFileFormat(), outputStream);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BFMachine bFMachine = new BFMachine(this.program, this.input);
        bFMachine.run();
        String string = bFMachine.getOutput();
        for (String string2 : string.split("\n")) {
            arrayList.add(string2);
        }
        UFont uFont = new UFont("Monospaced", 0, 14);
        return new GraphicStrings(arrayList, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, null, GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
    }

    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Turing)", this.getClass());
    }
}

