/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2014, Arnaud Roques
 *
 * Project Info:  http://plantuml.sourceforge.net
 * 
 * This file is part of PlantUML.
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PlantUML distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * Original Author:  Arnaud Roques
 * 
 * Revision $Revision: 12235 $
 *
 */
package net.sourceforge.plantuml.png;

import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.imageio.ImageIO;

import net.sourceforge.plantuml.Log;

public class PngIO {

	private static final String copyleft = "Generated by http://plantuml.sourceforge.net";

	public static void write(RenderedImage image, File file, int dpi) throws IOException {
		write(image, file, null, dpi);
	}

	public static void write(RenderedImage image, OutputStream os, int dpi) throws IOException {
		write(image, os, null, dpi);
	}

	public static void write(RenderedImage image, File file, String metadata, int dpi) throws IOException {
		OutputStream os = null;
		try {
			os = new BufferedOutputStream(new FileOutputStream(file));
			write(image, os, metadata, dpi);
		} finally {
			if (os != null) {
				os.close();
			}
		}
		Log.debug("File is " + file);
		Log.debug("File size " + file.length());
		if (file.length() == 0) {
			Log.error("File size is zero: " + file);
			ImageIO.write(image, "png", file);
		}
	}

	public static void write(RenderedImage image, OutputStream os, String metadata, int dpi) throws IOException {
		write(image, os, metadata, dpi, null);
	}

	public static void write(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData)
			throws IOException {
		if (metadata != null && checkPNGMetadata()) {
			PngIOMetadata.writeWithMetadata(image, os, metadata, dpi, debugData);
		} else {
			ImageIO.write(image, "png", os);
		}

	}

	static boolean checkPNGMetadata() {
		try {
			final Class cl = Class.forName("com.sun.imageio.plugins.png.PNGMetadata");
			if (cl == null) {
				Log.info("Cannot load com.sun.imageio.plugins.png.PNGMetadata");
				return false;
			}
			Log.info("Ok for com.sun.imageio.plugins.png.PNGMetadata");
			return true;
		} catch (Exception e) {
			Log.info("Error loading com.sun.imageio.plugins.png.PNGMetadata " + e);
			return false;
		}
	}

}
