/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2014, Arnaud Roques
 *
 * Project Info:  http://plantuml.sourceforge.net
 * 
 * This file is part of PlantUML.
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PlantUML distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * Original Author:  Arnaud Roques
 * 
 * Revision $Revision: 4636 $
 *
 */
package net.sourceforge.plantuml.sequencediagram.puma;

public class PSegment {

	private final double minsize;
	private double startx;
	private double endx;

	public PSegment(double minsize) {
		this.minsize = minsize;
		this.startx = 0;
		this.endx = minsize;
	}

	public double getMinsize() {
		return minsize;
	}

	public void push(double delta) {
		this.startx += delta;
		this.endx += delta;
	}

	public String getDebugPosition() {
		return "" + ((int) startx) + "-" + ((int) endx);
	}

	public double getPosition(double position) {
		if (position == 0) {
			return startx;
		}
		if (position == 1) {
			return endx;
		}
		throw new UnsupportedOperationException();
	}

}
