/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Properties;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ProtectedCommand;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.Version;

public abstract class AbstractPSystem
implements Diagram {
    private UmlSource source;

    private String getVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PlantUML version ");
        stringBuilder.append(Version.versionString());
        stringBuilder.append("(" + Version.compileTimeString() + ")\n");
        stringBuilder.append("(" + (Object)((Object)License.getCurrent()) + " source distribution)\n");
        Properties properties = System.getProperties();
        stringBuilder.append(properties.getProperty("java.runtime.name"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("java.vm.name"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("java.runtime.version"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("os.name"));
        return stringBuilder.toString();
    }

    public final String getMetadata() {
        if (this.source == null) {
            return this.getVersion();
        }
        return this.source.getPlainString() + "\n" + this.getVersion();
    }

    public final UmlSource getSource() {
        return this.source;
    }

    public final void setSource(UmlSource umlSource) {
        this.source = umlSource;
    }

    public int getNbImages() {
        return 1;
    }

    public Display getTitle() {
        if (this.source == null) {
            return Display.empty();
        }
        return this.source.getTitle();
    }

    public String getWarningOrError() {
        return null;
    }

    public void makeDiagramReady() {
    }

    public boolean isOk() {
        return true;
    }

    public CommandExecutionResult executeCommand(Command protectedCommand, BlocLines blocLines) {
        protectedCommand = new ProtectedCommand(protectedCommand);
        return protectedCommand.execute(this, blocLines);
    }

    public boolean hasUrl() {
        return false;
    }
}

