/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemBuilder;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockUml {
    private final List<CharSequence2> data;
    private final int startLine;
    private Diagram system;
    private static final Pattern patternFilename = MyPattern.cmpile("^@start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");

    BlockUml(String ... stringArray) {
        this(BlockUml.convert(stringArray), 0);
    }

    public String getFlashData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence2 charSequence2 : this.data) {
            stringBuilder.append(charSequence2);
            stringBuilder.append('\r');
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static List<CharSequence2> convert(String ... stringArray) {
        return BlockUml.convert(Arrays.asList(stringArray));
    }

    public static List<CharSequence2> convert(List<String> list) {
        ArrayList<CharSequence2> arrayList = new ArrayList<CharSequence2>();
        LineLocationImpl lineLocationImpl = new LineLocationImpl("block", null);
        for (String string : list) {
            lineLocationImpl = lineLocationImpl.oneLineRead();
            arrayList.add(new CharSequence2Impl(string, lineLocationImpl));
        }
        return arrayList;
    }

    public BlockUml(List<CharSequence2> list, int n) {
        this.startLine = n;
        CharSequence2 charSequence2 = list.get(0).trin();
        if (!charSequence2.startsWith("@start")) {
            throw new IllegalArgumentException();
        }
        this.data = new ArrayList<CharSequence2>(list);
    }

    public String getFileOrDirname() {
        if (OptionFlags.getInstance().isWord()) {
            return null;
        }
        Matcher matcher = patternFilename.matcher(StringUtils.trin(this.data.get(0).toString()));
        boolean bl = matcher.find();
        if (!bl) {
            return null;
        }
        String string = matcher.group(1);
        int n = string.indexOf(44);
        if (n != -1) {
            string = string.substring(0, n);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("<>|".indexOf(c) == -1) continue;
            return null;
        }
        if (string.startsWith("file://")) {
            string = string.substring("file://".length());
        }
        return string;
    }

    public Diagram getDiagram() {
        if (this.system == null) {
            this.system = new PSystemBuilder().createPSystem(this.data);
        }
        return this.system;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final List<CharSequence2> getData() {
        return this.data;
    }
}

