/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileGroup;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.SourceFileReader2;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.command.UmlDiagramFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.ftp.FtpServer;
import net.sourceforge.plantuml.objectdiagram.ObjectDiagramFactory;
import net.sourceforge.plantuml.png.MetadataTag;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.swing.MainWindow2;
import net.sourceforge.plantuml.ugraphic.SpriteGrayLevel;
import net.sourceforge.plantuml.ugraphic.SpriteUtils;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Run {
    public static void main(String[] stringArray) throws IOException, InterruptedException {
        long l = System.currentTimeMillis();
        Option option = new Option(stringArray);
        if (OptionFlags.getInstance().isEncodesprite()) {
            Run.encodeSprite(option.getResult());
            return;
        }
        if (OptionFlags.getInstance().isVerbose()) {
            Log.info("PlantUML Version " + Version.versionString());
            Log.info("GraphicsEnvironment.isHeadless() " + GraphicsEnvironment.isHeadless());
        }
        if (GraphicsEnvironment.isHeadless()) {
            Log.info("Forcing -Djava.awt.headless=true");
            System.setProperty("java.awt.headless", "true");
            Log.info("java.awt.headless set as true");
        }
        if (OptionFlags.getInstance().isPrintFonts()) {
            Run.printFonts();
            return;
        }
        if (option.getFtpPort() != -1) {
            Run.goFtp(option);
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (option.isPattern()) {
            Run.managePattern();
        } else if (OptionFlags.getInstance().isGui()) {
            File file;
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<String> list = option.getResult();
            File file2 = null;
            if (list.size() == 1 && (file = new File(list.get(0))).exists() && file.isDirectory()) {
                file2 = file;
            }
            new MainWindow2(option, file2);
        } else if (option.isPipe() || option.isSyntax()) {
            Run.managePipe(option);
            bl2 = true;
        } else if (option.isFailfast2()) {
            long l2 = System.currentTimeMillis();
            option.setCheckOnly(true);
            bl = Run.manageAllFiles(option);
            option.setCheckOnly(false);
            if (option.isDuration()) {
                double d = (double)(System.currentTimeMillis() - l2) / 1000.0;
                Log.error("Check Duration = " + d + " seconds");
            }
            if (!bl) {
                bl = Run.manageAllFiles(option);
            }
            bl2 = true;
        } else {
            bl = Run.manageAllFiles(option);
            bl2 = true;
        }
        if (option.isDuration()) {
            double d = (double)(System.currentTimeMillis() - l) / 1000.0;
            Log.error("Duration = " + d + " seconds");
        }
        if (bl) {
            Log.error("Some diagram description contains errors");
            System.exit(1);
        }
        if (bl2 && OptionFlags.getInstance().isSystemExit()) {
            System.exit(0);
        }
    }

    private static void encodeSprite(List<String> list) throws IOException {
        File file;
        SpriteGrayLevel spriteGrayLevel = SpriteGrayLevel.GRAY_16;
        boolean bl = false;
        if (list.size() > 1 && list.get(0).matches("(4|8|16)z?")) {
            if (list.get(0).startsWith("8")) {
                spriteGrayLevel = SpriteGrayLevel.GRAY_8;
            }
            if (list.get(0).startsWith("4")) {
                spriteGrayLevel = SpriteGrayLevel.GRAY_4;
            }
            bl = StringUtils.goLowerCase(list.get(0)).endsWith("z");
            file = new File(list.get(1));
        } else {
            file = new File(list.get(0));
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        String string = Run.getSpriteName(file);
        String string2 = bl ? SpriteUtils.encodeCompressed(bufferedImage, string, spriteGrayLevel) : SpriteUtils.encode(bufferedImage, string, spriteGrayLevel);
        System.out.println(string2);
    }

    private static String getSpriteName(File file) {
        String string = Run.getSpriteNameInternal(file);
        if (string.length() == 0) {
            return "test";
        }
        return string;
    }

    private static String getSpriteNameInternal(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : file.getName().toCharArray()) {
            if (!("" + c).matches("[\\p{L}0-9_]")) {
                return stringBuilder.toString();
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static void goFtp(Option option) throws IOException {
        int n = option.getFtpPort();
        System.err.println("ftpPort=" + n);
        FtpServer ftpServer = new FtpServer(n, option.getFileFormat());
        ftpServer.go();
    }

    public static void printFonts() {
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Object[] objectArray = fontArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Font font = objectArray[i];
            System.out.println("f=" + font + "/" + font.getPSName() + "/" + font.getName() + "/" + font.getFontName() + "/" + font.getFamily());
        }
        for (Object object : objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            System.out.println("n=" + (String)object);
        }
    }

    private static void managePattern() {
        Run.printPattern(new SequenceDiagramFactory());
        Run.printPattern(new ClassDiagramFactory());
        Run.printPattern(new ActivityDiagramFactory());
        Run.printPattern(new DescriptionDiagramFactory());
        Run.printPattern(new StateDiagramFactory());
        Run.printPattern(new ObjectDiagramFactory());
    }

    private static void printPattern(UmlDiagramFactory umlDiagramFactory) {
        System.out.println();
        System.out.println(umlDiagramFactory.getClass().getSimpleName().replaceAll("Factory", ""));
        List<String> list = umlDiagramFactory.getDescription();
        for (String string : list) {
            System.out.println(string);
        }
    }

    private static void managePipe(Option option) throws IOException {
        String string = option.getCharset();
        BufferedReader bufferedReader = string == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(System.in, string));
        Run.managePipe(option, bufferedReader, System.out);
    }

    public static void managePipe(Option option, BufferedReader bufferedReader, PrintStream printStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        String string2 = stringBuilder.toString();
        if (!string2.contains("@startuml")) {
            string2 = "@startuml\n" + string2 + "\n@enduml";
        }
        SourceStringReader sourceStringReader = new SourceStringReader(new Defines(), string2, option.getConfig());
        if (option.isSyntax()) {
            Diagram diagram = sourceStringReader.getBlocks().get(0).getDiagram();
            if (diagram instanceof UmlDiagram) {
                printStream.println(((UmlDiagram)diagram).getUmlDiagramType().name());
                printStream.println(diagram.getDescription());
            } else if (diagram instanceof PSystemError) {
                printStream.println("ERROR");
                PSystemError pSystemError = (PSystemError)diagram;
                printStream.println(pSystemError.getHigherErrorPosition());
                for (ErrorUml errorUml : pSystemError.getErrorsUml()) {
                    printStream.println(errorUml.getError());
                }
            } else {
                printStream.println("OTHER");
                printStream.println(diagram.getDescription());
            }
        } else if (option.isPipe()) {
            sourceStringReader.generateImage(printStream, 0, option.getFileFormatOption());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean manageAllFiles(Option option) throws IOException, InterruptedException {
        boolean bl;
        block3: {
            File file = null;
            try {
                if (OptionFlags.getInstance().isWord()) {
                    File file2 = new File(option.getResult().get(0));
                    File file3 = new File(file2, "javaisrunning.tmp");
                    file3.delete();
                    file = new File(file2, "javaumllock.tmp");
                }
                bl = Run.processArgs(option);
                Object var5_5 = null;
                if (file == null) break block3;
                file.delete();
            }
            catch (Throwable throwable) {
                block4: {
                    Object var5_6 = null;
                    if (file == null) break block4;
                    file.delete();
                }
                throw throwable;
            }
        }
        return bl;
    }

    private static boolean processArgs(Option option) throws IOException, InterruptedException {
        if (!(option.isDecodeurl() || option.getNbThreads() <= 0 || option.isCheckOnly() || OptionFlags.getInstance().isMetadata())) {
            return Run.multithread(option);
        }
        boolean bl = false;
        for (String string : option.getResult()) {
            Object object;
            if (option.isDecodeurl()) {
                object = TranscoderUtil.getDefaultTranscoder();
                System.out.println("@startuml");
                System.out.println(object.decode(string));
                System.out.println("@enduml");
                continue;
            }
            object = new FileGroup(string, option.getExcludes(), option);
            for (File file : ((FileGroup)object).getFiles()) {
                try {
                    boolean bl2 = Run.manageFileInternal(file, option);
                    if (bl2) {
                        bl = true;
                    }
                    if (!bl2 || !option.isFailfastOrFailfast2()) continue;
                    return true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bl;
    }

    private static boolean multithread(final Option option) throws InterruptedException {
        Log.info("Using several threads: " + option.getNbThreads());
        ExecutorService executorService = Executors.newFixedThreadPool(option.getNbThreads());
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        for (String string : option.getResult()) {
            FileGroup fileGroup = new FileGroup(string, option.getExcludes(), option);
            for (final File file : fileGroup.getFiles()) {
                executorService.submit(new Runnable(){

                    public void run() {
                        if (atomicBoolean.get() && option.isFailfastOrFailfast2()) {
                            return;
                        }
                        try {
                            boolean bl = Run.manageFileInternal(file, option);
                            if (bl) {
                                atomicBoolean.set(true);
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                });
            }
        }
        executorService.shutdown();
        executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        return atomicBoolean.get();
    }

    private static boolean manageFileInternal(File file, Option option) throws IOException, InterruptedException {
        if (OptionFlags.getInstance().isMetadata()) {
            System.out.println("------------------------");
            System.out.println(file);
            System.out.println();
            System.out.println(new MetadataTag(file, "plantuml").getData());
            System.out.println("------------------------");
            return false;
        }
        ISourceFileReader iSourceFileReader = option.getOutputFile() == null ? new SourceFileReader(option.getDefaultDefines(), file, option.getOutputDir(), option.getConfig(), option.getCharset(), option.getFileFormatOption()) : new SourceFileReader2(option.getDefaultDefines(), file, option.getOutputFile(), option.getConfig(), option.getCharset(), option.getFileFormatOption());
        if (option.isComputeurl()) {
            List<String> list = iSourceFileReader.getEncodedUrl();
            for (String string : list) {
                System.out.println(string);
            }
            return false;
        }
        if (option.isCheckOnly()) {
            boolean bl = iSourceFileReader.hasError();
            List<GeneratedImage> list = iSourceFileReader.getGeneratedImages();
            Run.hasErrors(file, list);
            return bl;
        }
        List<GeneratedImage> list = iSourceFileReader.getGeneratedImages();
        return Run.hasErrors(file, list);
    }

    private static boolean hasErrors(File file, List<GeneratedImage> list) throws IOException {
        boolean bl = false;
        for (GeneratedImage generatedImage : list) {
            int n = generatedImage.lineErrorRaw();
            if (n == -1) continue;
            Log.error("Error line " + n + " in file: " + file.getCanonicalPath());
            bl = true;
        }
        return bl;
    }
}

