/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static String getPlateformDependentAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    public static List<String> getWithNewlines(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\\' && i < charSequence.length() - 1) {
                char c2 = charSequence.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                if (c2 != '\\') continue;
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString());
        return Collections.unmodifiableList(arrayList);
    }

    public static final List<String> getSplit(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            arrayList.add(matcher.group(i));
        }
        return arrayList;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && StringUtils.trin(string).length() > 0;
    }

    public static boolean isNotEmpty(List<? extends CharSequence> list) {
        return list != null && list.size() > 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || StringUtils.trin(string).length() == 0;
    }

    public static String manageHtml(String string) {
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }

    public static String unicode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|') {
                char c2 = c;
                stringBuilder.append("&#" + c2 + ";");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String unicodeForHtml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|' || c == '<' || c == '>') {
                char c2 = c;
                stringBuilder.append("&#" + c2 + ";");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String unicodeForHtml(Display display) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < display.size(); ++i) {
            stringBuilder.append(StringUtils.unicodeForHtml(display.get(i).toString()));
            if (i >= display.size() - 1) continue;
            stringBuilder.append("<br>");
        }
        return stringBuilder.toString();
    }

    public static String manageArrowForSequence(String string) {
        string = string.replace('=', '-').toLowerCase();
        return string;
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String goUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static char goUpperCase(char c) {
        return StringUtils.goUpperCase("" + c).charAt(0);
    }

    public static String goLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static char goLowerCase(char c) {
        return StringUtils.goLowerCase("" + c).charAt(0);
    }

    public static String manageArrowForCuca(String string) {
        Direction direction = StringUtils.getArrowDirection(string);
        string = string.replace('=', '-');
        string = string.replaceAll("\\w*", "");
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string = string.replaceAll("-+", "-");
        }
        if (string.length() == 2 && (direction == Direction.UP || direction == Direction.DOWN)) {
            string = string.replaceFirst("-", "--");
        }
        return string;
    }

    public static String manageQueueForCuca(String string) {
        Direction direction = StringUtils.getQueueDirection(string);
        string = string.replace('=', '-');
        string = string.replaceAll("\\w*", "");
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string = string.replaceAll("-+", "-");
        }
        if (string.length() == 1 && (direction == Direction.UP || direction == Direction.DOWN)) {
            string = string.replaceFirst("-", "--");
        }
        return string;
    }

    public static Direction getArrowDirection(String string) {
        if (string.endsWith(">")) {
            return StringUtils.getQueueDirection(string.substring(0, string.length() - 1));
        }
        if (string.startsWith("<")) {
            if (string.length() == 2) {
                return Direction.LEFT;
            }
            return Direction.UP;
        }
        throw new IllegalArgumentException(string);
    }

    public static Direction getQueueDirection(String string) {
        if (string.indexOf(60) != -1 || string.indexOf(62) != -1) {
            throw new IllegalArgumentException(string);
        }
        if ((string = string.toLowerCase()).contains("left")) {
            return Direction.LEFT;
        }
        if (string.contains("right")) {
            return Direction.RIGHT;
        }
        if (string.contains("up")) {
            return Direction.UP;
        }
        if (string.contains("down")) {
            return Direction.DOWN;
        }
        if (string.contains("l")) {
            return Direction.LEFT;
        }
        if (string.contains("r")) {
            return Direction.RIGHT;
        }
        if (string.contains("u")) {
            return Direction.UP;
        }
        if (string.contains("d")) {
            return Direction.DOWN;
        }
        if (string.length() == 1) {
            return Direction.RIGHT;
        }
        return Direction.DOWN;
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String string, String string2) {
        if (string2.contains("\"") && string.length() > 1 && StringUtils.isDoubleQuote(string.charAt(0)) && StringUtils.isDoubleQuote(string.charAt(string.length() - 1))) {
            return string.substring(1, string.length() - 1);
        }
        if (string2.contains("(") && string.startsWith("(") && string.endsWith(")")) {
            return string.substring(1, string.length() - 1);
        }
        if (string2.contains("[") && string.startsWith("[") && string.endsWith("]")) {
            return string.substring(1, string.length() - 1);
        }
        if (string2.contains(":") && string.startsWith(":") && string.endsWith(":")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String string) {
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string, "\"([:");
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"' || c == '\u201c' || c == '\u201d' || c == '\u00ab' || c == '\u00bb';
    }

    public static boolean isCJK(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        Log.println("block=" + unicodeBlock);
        return false;
    }

    public static char hiddenLesserThan() {
        return '\u0005';
    }

    public static char hiddenBiggerThan() {
        return '\u0006';
    }

    public static char hiddenNewLine() {
        return '\t';
    }

    public static String hideComparatorCharacters(String string) {
        string = string.replace('<', StringUtils.hiddenLesserThan());
        string = string.replace('>', StringUtils.hiddenBiggerThan());
        return string;
    }

    public static String showComparatorCharacters(String string) {
        string = string.replace(StringUtils.hiddenLesserThan(), '<');
        string = string.replace(StringUtils.hiddenBiggerThan(), '>');
        return string;
    }

    public static int getWidth(Display display) {
        int n = 1;
        for (CharSequence charSequence : display) {
            if (n >= charSequence.length()) continue;
            n = charSequence.length();
        }
        return n;
    }

    public static int getHeight(List<? extends CharSequence> list) {
        return list.size();
    }

    public static int getHeight(Display display) {
        return display.size();
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    public static boolean isDiagramCacheable(String string) {
        if ((string = string.toLowerCase()).startsWith("@startuml\nversion\n")) {
            return false;
        }
        if (string.startsWith("@startuml\ncheckversion")) {
            return false;
        }
        if (string.startsWith("@startuml\ntestdot\n")) {
            return false;
        }
        return !string.startsWith("@startuml\nsudoku\n");
    }

    public static List<String> splitComma(String string) {
        string = StringUtils.trin(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = MyPattern.cmpile("([\\p{L}0-9_.]+|[%g][^%g]+[%g])");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(0)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static String getAsHtml(Color color) {
        if (color == null) {
            return null;
        }
        return StringUtils.getAsHtml(color.getRGB());
    }

    public static String getAsSvg(ColorMapper colorMapper, HtmlColor htmlColor) {
        if (htmlColor == null) {
            return "none";
        }
        if (htmlColor instanceof HtmlColorTransparent) {
            return "#FFFFFF";
        }
        return StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColor));
    }

    public static String getAsHtml(int n) {
        int n2 = 0xFFFFFF & n;
        String string = "000000" + Integer.toHexString(n2).toUpperCase();
        string = string.substring(string.length() - 6);
        return "#" + string;
    }

    public static String getUid(String string, int n) {
        return string + String.format("%04d", n);
    }

    public static <O> List<O> merge(List<O> list, List<O> list2) {
        ArrayList<O> arrayList = new ArrayList<O>(list);
        arrayList.addAll(list2);
        return Collections.unmodifiableList(arrayList);
    }

    public static boolean endsWithBackslash(String string) {
        return string.endsWith("\\") && !string.endsWith("\\\\");
    }

    public static String manageGuillemetStrict(String string) {
        if (string.startsWith("<< ")) {
            string = "\u00ab" + string.substring(3);
        } else if (string.startsWith("<<")) {
            string = "\u00ab" + string.substring(2);
        }
        if (string.endsWith(" >>")) {
            string = string.substring(0, string.length() - 3) + "\u00bb";
        } else if (string.endsWith(">>")) {
            string = string.substring(0, string.length() - 2) + "\u00bb";
        }
        return string;
    }

    public static String manageGuillemet(String string) {
        return string.replaceAll("\\<\\<([^<>]+)\\>\\>", "\u00ab$1\u00bb");
    }

    public static String manageUnicodeNotationUplus(String string) {
        Pattern pattern = Pattern.compile("\\<U\\+([0-9a-fA-F]{4})\\>");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            int n = Integer.parseInt(string2, 16);
            char c = (char)n;
            matcher.appendReplacement(stringBuffer, "" + c);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String manageAmpDiese(String string) {
        Pattern pattern = Pattern.compile("\\&#([0-9]+);");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            char c = (char)Integer.parseInt(string2);
            matcher.appendReplacement(stringBuffer, "" + c);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String manageTildeArobaseStart(String string) {
        string = string.replaceAll("~@start", "@start");
        return string;
    }

    public static String trinNoTrace(CharSequence charSequence) {
        return charSequence.toString().trim();
    }

    public static String trin(CharSequence charSequence) {
        int n;
        int n2;
        if (charSequence.length() == 0) {
            return charSequence.toString();
        }
        for (n2 = 0; n2 < charSequence.length() && StringUtils.isSpaceOrTab(charSequence.charAt(n2)); ++n2) {
        }
        for (n = charSequence.length() - 1; n >= n2 && StringUtils.isSpaceOrTab(charSequence.charAt(n)); --n) {
        }
        if (n2 == 0 && n == charSequence.length() - 1) {
            return charSequence.toString();
        }
        return charSequence.subSequence(n2, n + 1).toString();
    }

    public static List<String> splitHiddenNewLine(String string) {
        return Arrays.asList(string.split("" + StringUtils.hiddenNewLine()));
    }

    public static String manageNewLine(String string) {
        return string.replace(StringUtils.hiddenNewLine(), '\n');
    }
}

