/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.regex.MyPattern;

public class UrlBuilder {
    private static final String URL_PATTERN_OLD = "\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{((?:[^{}]|\\{[^{}]*\\})+)\\})?(?:[%s]*([^\\]\\[]+))?\\]\\]";
    private static final String URL_PATTERN = "\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{(" + UrlBuilder.levelN(3) + ")" + "\\})?(?:[%s]*([^\\]\\[]+))?\\]\\]";
    private final String topurl;
    private ModeUrl mode;

    private static String level0() {
        return "(?:[^{}]|\\{[^{}]*\\})+";
    }

    private static String levelN(int n) {
        if (n == 0) {
            return UrlBuilder.level0();
        }
        return "(?:[^{}]|\\{" + UrlBuilder.levelN(n - 1) + "\\})+";
    }

    public UrlBuilder(String string, ModeUrl modeUrl) {
        this.topurl = string;
        this.mode = modeUrl;
    }

    public static String multilineTooltip(String string) {
        Pattern pattern = MyPattern.cmpile("(?i)^(" + URL_PATTERN + ")?(.*)$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        String string2 = matcher.group(1);
        if (string2 == null) {
            return string;
        }
        String string3 = matcher.group(matcher.groupCount());
        string2 = string2.replaceAll("\\\\n", "\n");
        return string2 + string3;
    }

    public Url getUrl(String string) {
        Pattern pattern;
        if (this.mode == ModeUrl.STRICT) {
            pattern = MyPattern.cmpile("(?i)^" + URL_PATTERN + "$");
        } else if (this.mode == ModeUrl.AT_START) {
            pattern = MyPattern.cmpile("(?i)^" + URL_PATTERN + ".*");
        } else if (this.mode == ModeUrl.AT_END) {
            pattern = MyPattern.cmpile("(?i).*" + URL_PATTERN + "$");
        } else if (this.mode == ModeUrl.ANYWHERE) {
            pattern = MyPattern.cmpile("(?i).*" + URL_PATTERN + ".*");
        } else {
            throw new IllegalStateException();
        }
        Matcher matcher = pattern.matcher(StringUtils.trinNoTrace(string));
        if (!matcher.matches()) {
            return null;
        }
        String string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(1));
        if (!string2.startsWith("http:") && !string2.startsWith("https:") && this.topurl != null) {
            string2 = this.topurl + string2;
        }
        return new Url(string2, matcher.group(2), matcher.group(3));
    }

    public static String getRegexp() {
        return URL_PATTERN;
    }

    public static String purgeUrl(String string) {
        Pattern pattern = MyPattern.cmpile("[%s]*" + URL_PATTERN + "[%s]*");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        String string2 = matcher.group(0);
        int n = string.indexOf(string2);
        return string.substring(0, n) + string.substring(n + string2.length());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModeUrl {
        STRICT,
        AT_START,
        ANYWHERE,
        AT_END;

    }
}

