/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionIf
implements Instruction,
InstructionCollection {
    private final List<Branch> thens = new ArrayList<Branch>();
    private Branch elseBranch;
    private final ISkinParam skinParam;
    private final Instruction parent;
    private Branch current;
    private final LinkRendering topInlinkRendering;
    private LinkRendering afterEndwhile;
    private final Swimlane swimlane;
    private Display note;
    private NotePosition position;

    public InstructionIf(Swimlane swimlane, Instruction instruction, Display display, Display display2, LinkRendering linkRendering, HtmlColor htmlColor, ISkinParam iSkinParam) {
        this.parent = instruction;
        this.skinParam = iSkinParam;
        this.topInlinkRendering = linkRendering;
        this.swimlane = swimlane;
        this.thens.add(new Branch(swimlane, display2, display, htmlColor));
        this.current = this.thens.get(0);
    }

    @Override
    public void add(Instruction instruction) {
        this.current.add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        for (Branch branch : this.thens) {
            branch.updateFtile(ftileFactory);
        }
        if (this.elseBranch == null) {
            this.elseBranch = new Branch(this.swimlane, Display.NULL, Display.NULL, null);
        }
        this.elseBranch.updateFtile(ftileFactory);
        Object object = ftileFactory.createIf(this.swimlane, this.thens, this.elseBranch, this.afterEndwhile, this.topInlinkRendering);
        if (this.note != null) {
            object = new FtileWithNoteOpale((Ftile)object, this.note, this.position, this.skinParam, false);
        }
        return object;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public boolean swithToElse2(Display display, LinkRendering linkRendering) {
        if (this.elseBranch != null) {
            return false;
        }
        this.current.setInlinkRendering(linkRendering);
        this.current = this.elseBranch = new Branch(this.swimlane, display, Display.NULL, null);
        return true;
    }

    public void elseIf(Display display, Display display2, LinkRendering linkRendering, HtmlColor htmlColor) {
        if (this.elseBranch != null) {
            throw new IllegalStateException();
        }
        this.current.setInlinkRendering(linkRendering);
        this.current = new Branch(this.swimlane, display2, display, htmlColor);
        this.thens.add(this.current);
    }

    public void endif(LinkRendering linkRendering) {
        if (this.elseBranch == null) {
            this.elseBranch = new Branch(this.swimlane, Display.NULL, Display.NULL, null);
        }
        this.current.setInlinkRendering(linkRendering);
    }

    @Override
    public final boolean kill() {
        return this.current.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.topInlinkRendering;
    }

    @Override
    public boolean addNote(Display display, NotePosition notePosition) {
        if (this.current.isEmpty()) {
            this.note = display;
            this.position = notePosition;
            return true;
        }
        return this.current.addNote(display, notePosition);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.swimlane != null) {
            hashSet.add(this.swimlane);
        }
        for (Branch branch : this.thens) {
            hashSet.addAll(branch.getSwimlanes());
        }
        hashSet.addAll(this.elseBranch.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public Instruction getLast() {
        if (this.elseBranch == null) {
            return this.thens.get(this.thens.size() - 1).getLast();
        }
        return this.elseBranch.getLast();
    }

    public void afterEndwhile(LinkRendering linkRendering) {
        this.afterEndwhile = linkRendering;
    }
}

