/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandActivityLong3
extends CommandMultilines2<ActivityDiagram3> {
    public CommandActivityLong3() {
        super(CommandActivityLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "^(.*)(;|(?<![/|<>}\\]])(?:[/<}\\]])|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<\\$\\w{1,999})(?<!\\>)(?:\\>)|(?<!\\|.{1,999})(?:\\|))$";
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), CommandActivityLong3.color().getRegex(), new RegexLeaf(":"), new RegexLeaf("DATA", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public CommandExecutionResult executeNow(ActivityDiagram3 activityDiagram3, BlocLines blocLines) {
        blocLines = blocLines.removeEmptyColumns();
        RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        Colors colors = CommandActivityLong3.color().getColor(regexResult, activityDiagram3.getSkinParam().getIHtmlColorSet());
        BoxStyle boxStyle = BoxStyle.fromChar(blocLines.getLastChar());
        blocLines = blocLines.removeStartingAndEnding2(regexResult.get("DATA", 0));
        activityDiagram3.addActivity(blocLines.toDisplay(), boxStyle, null, colors);
        return CommandExecutionResult.ok();
    }
}

