/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileHeightFixed
extends AbstractFtile {
    private final Ftile tile;
    private final double fixedHeight;

    public FtileHeightFixed(Ftile ftile, double d) {
        super(ftile.shadowing());
        this.tile = ftile;
        this.fixedHeight = d;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.tile.getOutLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        return this.tile.calculateDimension(stringBounder).translate(this.getTranslate(stringBounder)).fixedHeight(this.fixedHeight);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        if (((Dimension2D)ftileGeometry).getHeight() > this.fixedHeight) {
            throw new IllegalStateException();
        }
        return new UTranslate(0.0, (this.fixedHeight - ((Dimension2D)ftileGeometry).getHeight()) / 2.0);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        uGraphic.apply(this.getTranslate(uGraphic.getStringBounder())).draw(this.tile);
    }
}

