/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileMargedRight
extends AbstractFtile {
    private final Ftile tile;
    private final double maxX;

    public FtileMargedRight(Ftile ftile, double d) {
        super(ftile.shadowing());
        this.tile = ftile;
        this.maxX = d;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.tile.getOutLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        if (ftileGeometry.getWidth() > this.maxX) {
            throw new IllegalStateException();
        }
        return new FtileGeometry(this.maxX, ftileGeometry.getHeight(), ftileGeometry.getLeft(), ftileGeometry.getInY(), ftileGeometry.getOutY());
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        uGraphic.draw(this.tile);
    }
}

