/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside2;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileIfLongHorizontal
extends AbstractFtile {
    private final double xSeparation = 20.0;
    private final List<Ftile> tiles;
    private final Ftile tile2;
    private final List<Ftile> diamonds;
    private final List<Ftile> couples = new ArrayList<Ftile>();
    private final HtmlColor arrowColor;

    private FtileIfLongHorizontal(List<Ftile> list, List<Ftile> list2, Ftile ftile, HtmlColor htmlColor) {
        super(list2.get(0).shadowing() || ftile.shadowing());
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < list.size(); ++i) {
            this.couples.add(new FtileAssemblySimple(list.get(i), list2.get(i)));
        }
        this.tile2 = ftile;
        this.diamonds = new ArrayList<Ftile>(list);
        this.tiles = new ArrayList<Ftile>(list2);
        this.arrowColor = htmlColor;
    }

    private static List<Ftile> alignDiamonds(List<Ftile> list, StringBounder stringBounder) {
        double d = 0.0;
        for (Ftile ftile : list) {
            d = Math.max(d, ftile.calculateDimension(stringBounder).getOutY());
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Ftile ftile = list.get(i);
            double d2 = d - ftile.calculateDimension(stringBounder).getOutY();
            assert (d2 >= 0.0);
            ftile = FtileUtils.addVerticalMargin(ftile, d2 / 2.0, 20.0);
            arrayList.add(ftile);
        }
        return arrayList;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            hashSet.add(this.getSwimlaneIn());
        }
        for (Ftile ftile : this.couples) {
            hashSet.addAll(ftile.getSwimlanes());
        }
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.couples.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> list, Branch branch, FontConfiguration fontConfiguration, LinkRendering linkRendering, LinkRendering linkRendering2) {
        Object object;
        Ftile ftile;
        Object object2;
        TextBlock textBlock;
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Branch list22 : list) {
            arrayList.add(new FtileMinWidth(list22.getFtile(), 30.0));
        }
        FtileMinWidth ftileMinWidth = new FtileMinWidth(branch.getFtile(), 30.0);
        ArrayList<Ftile> arrayList2 = new ArrayList<Ftile>();
        for (Branch branch2 : list) {
            textBlock = branch2.getLabelPositive().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
            object2 = branch2.getLabelTest().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
            FtileDiamondInside2 htmlColor4 = new FtileDiamondInside2(branch2.shadowing(), htmlColor2, htmlColor, swimlane, (TextBlock)object2);
            htmlColor4 = htmlColor4.withNorth(textBlock);
            arrayList2.add(htmlColor4);
        }
        TextBlock textBlock2 = branch.getLabelPositive().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
        int n = arrayList2.size() - 1;
        arrayList2.set(n, ((FtileDiamondInside2)arrayList2.get(n)).withEast(textBlock2));
        List<Ftile> list2 = FtileIfLongHorizontal.alignDiamonds(arrayList2, ftileFactory.getStringBounder());
        textBlock = new FtileIfLongHorizontal(list2, arrayList, ftileMinWidth, htmlColor3);
        object2 = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Ftile htmlColor5 = (Ftile)arrayList.get(i);
            ftile = list2.get(i);
            object = FtileIfWithLinks.getInColor(list.get(i), htmlColor3);
            TextBlock textBlock3 = textBlock;
            textBlock3.getClass();
            object2.add((FtileIfLongHorizontal)textBlock3.new ConnectionVerticalIn(ftile, htmlColor5, (HtmlColor)(object == null ? htmlColor3 : object)));
            TextBlock textBlock4 = textBlock;
            textBlock4.getClass();
            object2.add((FtileIfLongHorizontal)textBlock4.new ConnectionVerticalOut(htmlColor5, htmlColor3));
        }
        HtmlColor htmlColor4 = LinkRendering.getColor(linkRendering, htmlColor3);
        for (int i = 0; i < list2.size() - 1; ++i) {
            ftile = list2.get(i);
            object = list2.get(i + 1);
            TextBlock textBlock5 = textBlock;
            textBlock5.getClass();
            object2.add((FtileIfLongHorizontal)textBlock5.new ConnectionHorizontal(ftile, (Ftile)object, htmlColor4));
        }
        TextBlock textBlock6 = textBlock;
        textBlock6.getClass();
        object2.add((FtileIfLongHorizontal)textBlock6.new ConnectionIn(htmlColor4));
        TextBlock textBlock7 = textBlock;
        textBlock7.getClass();
        object2.add((FtileIfLongHorizontal)textBlock7.new ConnectionLastElseIn(FtileIfWithLinks.getInColor(branch, htmlColor3)));
        TextBlock textBlock8 = textBlock;
        textBlock8.getClass();
        object2.add((FtileIfLongHorizontal)textBlock8.new ConnectionLastElseOut(htmlColor3));
        HtmlColor htmlColor5 = LinkRendering.getColor(linkRendering2, htmlColor3);
        TextBlock textBlock9 = textBlock;
        textBlock9.getClass();
        object2.add((FtileIfLongHorizontal)textBlock9.new ConnectionHline(htmlColor5));
        return FtileUtils.addConnection((Ftile)textBlock, (Collection<Connection>)object2);
    }

    private static double getYdiamontOutToLeft(FtileGeometry ftileGeometry, StringBounder stringBounder) {
        return (ftileGeometry.getInY() + ftileGeometry.getOutY()) / 2.0;
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (this.couples.contains(ftile)) {
            return this.getTranslateCouple1(ftile, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry).getWidth() - ((Dimension2D)ftileGeometry2).getWidth();
        double d2 = (((Dimension2D)ftileGeometry).getHeight() - 0.0 - ((Dimension2D)ftileGeometry2).getHeight()) / 2.0 + 0.0;
        return new UTranslate(d, d2);
    }

    private UTranslate getTranslateDiamond1(Ftile ftile, StringBounder stringBounder) {
        int n = this.diamonds.indexOf(ftile);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        UTranslate uTranslate = this.getTranslateCouple1(this.couples.get(n), stringBounder);
        UTranslate uTranslate2 = this.couples.get(n).getTranslateFor(ftile, stringBounder);
        return uTranslate.compose(uTranslate2);
    }

    public UTranslate getTranslate1(Ftile ftile, StringBounder stringBounder) {
        int n = this.tiles.indexOf(ftile);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        UTranslate uTranslate = this.getTranslateCouple1(this.couples.get(n), stringBounder);
        UTranslate uTranslate2 = this.couples.get(n).getTranslateFor(ftile, stringBounder);
        return uTranslate.compose(uTranslate2);
    }

    private UTranslate getTranslateCouple1(Ftile ftile, StringBounder stringBounder) {
        double d = 0.0;
        for (Ftile ftile2 : this.couples) {
            FtileGeometry ftileGeometry = ftile2.calculateDimension(stringBounder);
            if (ftile2 == ftile) {
                return new UTranslate(d, 25.0);
            }
            d += ftileGeometry.getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Ftile ftile : this.couples) {
            uGraphic.apply(this.getTranslateCouple1(ftile, stringBounder)).draw(ftile);
        }
        uGraphic.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
    }

    private FtileGeometry calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = new Dimension2DDouble(0.0, 0.0);
        for (Ftile ftile : this.couples) {
            dimension2D = Dimension2DDouble.mergeLR(dimension2D, ftile.calculateDimension(stringBounder));
        }
        FtileGeometry ftileGeometry = this.tile2.calculateDimension(stringBounder);
        dimension2D = Dimension2DDouble.mergeLR(dimension2D, ftileGeometry);
        dimension2D = Dimension2DDouble.delta(dimension2D, 20.0 * (double)this.couples.size(), 100.0);
        return new FtileGeometry(dimension2D, dimension2D.getWidth() / 2.0, 0.0);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>(this.tiles);
        arrayList.add(this.tile2);
        for (Ftile ftile : arrayList) {
            if (!ftile.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(ftileGeometry, ((Dimension2D)ftileGeometry).getWidth() / 2.0, 0.0, ((Dimension2D)ftileGeometry).getHeight());
        }
        return new FtileGeometry(ftileGeometry, ((Dimension2D)ftileGeometry).getWidth() / 2.0, 0.0);
    }

    class ConnectionHline
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionHline(HtmlColor htmlColor) {
            super(null, null);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder);
            ArrayList<Ftile> arrayList = new ArrayList<Ftile>(FtileIfLongHorizontal.this.couples);
            arrayList.add(FtileIfLongHorizontal.this.tile2);
            double d = ((Dimension2D)ftileGeometry).getWidth() / 2.0;
            double d2 = ((Dimension2D)ftileGeometry).getWidth() / 2.0;
            for (Ftile ftile : arrayList) {
                if (!ftile.calculateDimension(stringBounder).hasPointOut()) continue;
                UTranslate uTranslate = FtileIfLongHorizontal.this.getTranslateFor(ftile, stringBounder);
                double d3 = ftile.calculateDimension(stringBounder).translate(uTranslate).getLeft();
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            Snake snake = new Snake(this.arrowColor);
            snake.goUnmergeable();
            double d4 = ((Dimension2D)ftileGeometry).getHeight();
            snake.addPoint(d, d4);
            snake.addPoint(d2, d4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionVerticalOut
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalOut(Ftile ftile, HtmlColor htmlColor) {
            super(ftile, null);
            this.color = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            double d = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D point2D = this.getP1(stringBounder);
            if (point2D == null) {
                return;
            }
            Point2D.Double double_ = new Point2D.Double(point2D.getX(), d);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(double_);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return null;
            }
            Point2D point2D = ftileGeometry.getPointOut();
            return FtileIfLongHorizontal.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(point2D);
        }
    }

    class ConnectionVerticalIn
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalIn(Ftile ftile, Ftile ftile2, HtmlColor htmlColor) {
            super(ftile, ftile2);
            this.color = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            Point2D point2D = this.getFtile1().calculateDimension(stringBounder).getPointOut();
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(point2D);
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D point2D = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongHorizontal.this.getTranslate1(this.getFtile2(), stringBounder).getTranslated(point2D);
        }
    }

    class ConnectionLastElseOut
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseOut(HtmlColor htmlColor) {
            super(FtileIfLongHorizontal.this.tile2, null);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate = FtileIfLongHorizontal.this.getTranslate2(stringBounder);
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = uTranslate.getTranslated(ftileGeometry.getPointOut());
            double d = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D.Double double_ = new Point2D.Double(point2D.getX(), d);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(double_);
            uGraphic.draw(snake);
        }
    }

    class ConnectionLastElseIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseIn(HtmlColor htmlColor) {
            super((Ftile)FtileIfLongHorizontal.this.diamonds.get(FtileIfLongHorizontal.this.diamonds.size() - 1), FtileIfLongHorizontal.this.tile2);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            Point2D point2D = this.getP1(uGraphic.getStringBounder());
            UTranslate uTranslate = FtileIfLongHorizontal.this.getTranslate2(uGraphic.getStringBounder());
            Point2D point2D2 = uTranslate.getTranslated(this.getFtile2().calculateDimension(uGraphic.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D2.getX(), point2D.getY());
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft() * 2.0, FtileIfLongHorizontal.getYdiamontOutToLeft(ftileGeometry, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(double_);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor htmlColor) {
            super(null, (Ftile)FtileIfLongHorizontal.this.diamonds.get(0));
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            UTranslate uTranslate = FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile2(), uGraphic.getStringBounder());
            Point2D point2D = uTranslate.getTranslated(this.getFtile2().calculateDimension(uGraphic.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D point2D2 = FtileIfLongHorizontal.this.calculateDimensionInternal(uGraphic.getStringBounder()).getPointIn();
            snake.addPoint(point2D2);
            snake.addPoint(point2D.getX(), point2D2.getY());
            snake.addPoint(point2D);
            uGraphic.draw(snake);
        }
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionHorizontal(Ftile ftile, Ftile ftile2, HtmlColor htmlColor) {
            super(ftile, ftile2);
            this.color = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToRight());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft() * 2.0, FtileIfLongHorizontal.getYdiamontOutToLeft(ftileGeometry, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(double_);
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(0.0, FtileIfLongHorizontal.getYdiamontOutToLeft(ftileGeometry, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile2(), stringBounder).getTranslated(double_);
        }
    }
}

