/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileDiamondInside2
extends AbstractFtile {
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock label;
    private final TextBlock west;
    private final TextBlock east;
    private final TextBlock north;
    private final TextBlock south;

    public FtileDiamondInside2(boolean bl, HtmlColor htmlColor, HtmlColor htmlColor2, Swimlane swimlane, TextBlock textBlock) {
        this(bl, htmlColor, htmlColor2, swimlane, textBlock, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamondInside2 withNorth(TextBlock textBlock) {
        return new FtileDiamondInside2(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.label, textBlock, this.south, this.west, this.east);
    }

    public FtileDiamondInside2 withWest(TextBlock textBlock) {
        return new FtileDiamondInside2(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.south, textBlock, this.east);
    }

    public FtileDiamondInside2 withEast(TextBlock textBlock) {
        return new FtileDiamondInside2(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.south, this.west, textBlock);
    }

    public FtileDiamondInside2 withSouth(TextBlock textBlock) {
        return new FtileDiamondInside2(this.shadowing(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, textBlock, this.west, this.east);
    }

    private FtileDiamondInside2(boolean bl, HtmlColor htmlColor, HtmlColor htmlColor2, Swimlane swimlane, TextBlock textBlock, TextBlock textBlock2, TextBlock textBlock3, TextBlock textBlock4, TextBlock textBlock5) {
        super(bl);
        this.backColor = htmlColor;
        this.swimlane = swimlane;
        this.borderColor = htmlColor2;
        this.label = textBlock;
        this.west = textBlock4;
        this.east = textBlock5;
        this.north = textBlock2;
        this.south = textBlock3;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.label.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry = this.calculateDimensionAlone(stringBounder);
        uGraphic = uGraphic.apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5)).apply(new UChangeBackColor(this.backColor));
        uGraphic.draw(Diamond.asPolygon(this.shadowing(), ((Dimension2D)ftileGeometry).getWidth(), ((Dimension2D)ftileGeometry).getHeight()));
        this.north.drawU(uGraphic.apply(new UTranslate(4.0 + ((Dimension2D)ftileGeometry).getWidth() / 2.0, ((Dimension2D)ftileGeometry).getHeight())));
        this.south.drawU(uGraphic.apply(new UTranslate(4.0 + ((Dimension2D)ftileGeometry).getWidth() / 2.0, ((Dimension2D)ftileGeometry).getHeight())));
        double d = (((Dimension2D)ftileGeometry).getWidth() - dimension2D.getWidth()) / 2.0;
        double d2 = (((Dimension2D)ftileGeometry).getHeight() - dimension2D.getHeight()) / 2.0;
        this.label.drawU(uGraphic.apply(new UTranslate(d, d2)));
        Dimension2D dimension2D2 = this.west.calculateDimension(stringBounder);
        this.west.drawU(uGraphic.apply(new UTranslate(-dimension2D2.getWidth(), -dimension2D2.getHeight() + ((Dimension2D)ftileGeometry).getHeight() / 2.0)));
        Dimension2D dimension2D3 = this.east.calculateDimension(stringBounder);
        this.east.drawU(uGraphic.apply(new UTranslate(((Dimension2D)ftileGeometry).getWidth(), -dimension2D3.getHeight() + ((Dimension2D)ftileGeometry).getHeight() / 2.0)));
    }

    private FtileGeometry calculateDimensionAlone(StringBounder stringBounder) {
        Dimension2D dimension2D = this.label.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = dimension2D.getWidth() == 0.0 || dimension2D.getHeight() == 0.0 ? new Dimension2DDouble(24.0, 24.0) : Dimension2DDouble.delta(Dimension2DDouble.atLeast(dimension2D, 24.0, 24.0), 24.0, 0.0);
        return new FtileGeometry(dimension2D2, dimension2D2.getWidth() / 2.0, 0.0, dimension2D2.getHeight());
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionAlone(stringBounder);
        Dimension2D dimension2D = this.north.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry).getHeight() + dimension2D.getHeight();
        double d2 = ((Dimension2D)ftileGeometry).getWidth() / 2.0;
        double d3 = dimension2D.getWidth() > d2 ? d2 + dimension2D.getWidth() : ((Dimension2D)ftileGeometry).getWidth();
        return new FtileGeometry(d3, d, d2, 0.0, ((Dimension2D)ftileGeometry).getHeight());
    }
}

