/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.anim;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.ugraphic.MinMax;

public class AffineTransformation {
    private static final Pattern rotate = Pattern.compile("rotate\\s+(-?\\d+\\.?\\d*)");
    private static final Pattern shear = Pattern.compile("shear\\s+(-?\\d+\\.?\\d*)\\s+(-?\\d+\\.?\\d*)");
    private static final Pattern translate = Pattern.compile("translate\\s+(-?\\d+\\.?\\d*)\\s+(-?\\d+\\.?\\d*)");
    private static final Pattern scale = Pattern.compile("scale\\s+(-?\\d+\\.?\\d*)\\s+(-?\\d+\\.?\\d*)");
    private static final Pattern color = Pattern.compile("color\\s+.*");
    private final AffineTransform affineTransform;
    private Dimension2D dimension;

    private AffineTransformation(AffineTransform affineTransform) {
        this.affineTransform = affineTransform;
        if (affineTransform == null) {
            throw new IllegalArgumentException();
        }
    }

    private AffineTransformation compose(AffineTransformation affineTransformation) {
        AffineTransform affineTransform = new AffineTransform(this.affineTransform);
        affineTransform.concatenate(affineTransformation.affineTransform);
        return new AffineTransformation(affineTransform);
    }

    public static AffineTransformation from(AffineTransform affineTransform) {
        return new AffineTransformation(affineTransform);
    }

    static AffineTransformation create(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        AffineTransformation affineTransformation = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            AffineTransformation affineTransformation2 = AffineTransformation.createSimple(string2);
            if (affineTransformation2 == null) continue;
            if (affineTransformation == null) {
                affineTransformation = affineTransformation2;
                continue;
            }
            affineTransformation = affineTransformation.compose(affineTransformation2);
        }
        return affineTransformation;
    }

    private static AffineTransformation createSimple(String string) {
        Matcher matcher = rotate.matcher(StringUtils.trin(string));
        if (matcher.find()) {
            double d = Double.parseDouble(matcher.group(1));
            return new AffineTransformation(AffineTransform.getRotateInstance(d * Math.PI / 180.0));
        }
        matcher = shear.matcher(string);
        if (matcher.find()) {
            double d = Double.parseDouble(matcher.group(1));
            double d2 = Double.parseDouble(matcher.group(2));
            return new AffineTransformation(AffineTransform.getShearInstance(d, d2));
        }
        matcher = translate.matcher(string);
        if (matcher.find()) {
            double d = Double.parseDouble(matcher.group(1));
            double d3 = Double.parseDouble(matcher.group(2));
            return new AffineTransformation(AffineTransform.getTranslateInstance(d, d3));
        }
        matcher = scale.matcher(string);
        if (matcher.find()) {
            double d = Double.parseDouble(matcher.group(1));
            double d4 = Double.parseDouble(matcher.group(2));
            return new AffineTransformation(AffineTransform.getScaleInstance(d, d4));
        }
        matcher = color.matcher(string);
        if (matcher.find()) {
            return new AffineTransformation(new AffineTransform());
        }
        return null;
    }

    public final AffineTransform getAffineTransform() {
        return this.getAffineTransform(this.dimension);
    }

    private AffineTransform getAffineTransform(Dimension2D dimension2D) {
        if (dimension2D == null) {
            throw new IllegalStateException();
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(dimension2D.getWidth() / 2.0, dimension2D.getHeight() / 2.0);
        affineTransform.concatenate(this.affineTransform);
        affineTransform.translate(-dimension2D.getWidth() / 2.0, -dimension2D.getHeight() / 2.0);
        return affineTransform;
    }

    public void setDimension(Dimension2D dimension2D) {
        this.dimension = dimension2D;
    }

    public MinMax getMinMax(Dimension2D dimension2D) {
        MinMax minMax = MinMax.getEmpty(false);
        AffineTransform affineTransform = this.getAffineTransform(dimension2D);
        minMax = minMax.addPoint(affineTransform.transform(new Point2D.Double(0.0, 0.0), null));
        minMax = minMax.addPoint(affineTransform.transform(new Point2D.Double(0.0, dimension2D.getHeight()), null));
        minMax = minMax.addPoint(affineTransform.transform(new Point2D.Double(dimension2D.getWidth(), 0.0), null));
        minMax = minMax.addPoint(affineTransform.transform(new Point2D.Double(dimension2D.getWidth(), dimension2D.getHeight()), null));
        return minMax;
    }
}

