/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateClass
extends SingleLineCommand2<ClassDiagram> {
    public static final String CODE = "[^%s{}%g<>]+";
    public static final String CODE_NO_DOTDOT = "[^%s{}%g<>:]+";

    public CommandCreateClass() {
        super(CommandCreateClass.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(interface|enum|annotation|abstract[%s]+class|abstract|class)[%s]+"), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", "[%g](.+)[%g]"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("CODE1", "([^%s{}%g<>]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^%s{}%g<>]+)"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("DISPLAY2", "[%g](.+)[%g]")), new RegexLeaf("CODE3", "([^%s{}%g<>]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), new RegexLeaf("GENERIC", "(?:[%s]*\\<(" + GenericRegexProducer.PATTERN + ")\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), CommandCreateClass.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("EXTENDS", "([%s]+(extends)[%s]+((?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*(?:\\s*,\\s*(?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*)*))?"), new RegexLeaf("IMPLEMENTS", "([%s]+(implements)[%s]+((?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*(?:\\s*,\\s*(?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*)*))?"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult regexResult) {
        Object object;
        Object object2;
        String string;
        ILeaf iLeaf;
        LeafType leafType = LeafType.getLeafType(StringUtils.goUpperCase(regexResult.get("TYPE", 0)));
        Code code = Code.of(regexResult.getLazzy("CODE", 0)).eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
        String string2 = regexResult.getLazzy("DISPLAY", 0);
        String string3 = regexResult.get("STEREO", 0);
        String string4 = regexResult.get("GENERIC", 0);
        if (classDiagram.leafExist(code)) {
            iLeaf = classDiagram.getOrCreateLeaf(code, leafType, null);
            iLeaf.muteToType(leafType, null);
        } else {
            iLeaf = classDiagram.createLeaf(code, Display.getWithNewlines(string2), leafType, null);
        }
        if (string3 != null) {
            iLeaf.setStereotype(new Stereotype(string3, classDiagram.getSkinParam().getCircledCharacterRadius(), classDiagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), classDiagram.getSkinParam().getIHtmlColorSet()));
        }
        if (string4 != null) {
            iLeaf.setGeneric(string4);
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object2 = new UrlBuilder(classDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            object = ((UrlBuilder)object2).getUrl(string);
            iLeaf.addUrl((Url)object);
        }
        object2 = CommandCreateClass.color().getColor(regexResult, classDiagram.getSkinParam().getIHtmlColorSet());
        object = classDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LINECOLOR", 1));
        if (object != null) {
            object2 = ((Colors)object2).add(ColorType.LINE, (HtmlColor)object);
        }
        if (regexResult.get("LINECOLOR", 0) != null) {
            object2 = ((Colors)object2).addLegacyStroke(regexResult.get("LINECOLOR", 0));
        }
        iLeaf.setColors((Colors)object2);
        CommandCreateClassMultilines.manageExtends("EXTENDS", classDiagram, regexResult, iLeaf);
        CommandCreateClassMultilines.manageExtends("IMPLEMENTS", classDiagram, regexResult, iLeaf);
        return CommandExecutionResult.ok();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

