/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkClass
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkClass(UmlDiagramType umlDiagramType) {
        super(CommandLinkClass.getRegexConcat(umlDiagramType));
    }

    private static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)[%s]+)?"), new RegexOr(new RegexLeaf("ENT1", "(?:" + CommandLinkClass.optionalKeywords(umlDiagramType) + "[%s]+)?" + CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE1", "\\([%s]*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)[%s]*,[%s]*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)[%s]*\\)")), new RegexLeaf("[%s]*"), new RegexLeaf("FIRST_LABEL", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexConcat(new RegexLeaf("ARROW_HEAD1", "([%s]+o|[#\\[<*+^]|[<\\[]\\|)?"), new RegexLeaf("ARROW_BODY1", "([-=.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden|norank)(?:,#\\w+|,dotted|,dashed|,bold|,hidden|,norank)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("INSIDE", "(?:(0|\\(0\\)|\\(0|0\\))(?=[-=.~]))?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden|norank)(?:,#\\w+|,dotted|,dashed|,bold|,hidden|,norank)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-=.]*)"), new RegexLeaf("ARROW_HEAD2", "(o[%s]+|[#\\]>*+^]|\\|[>\\]])?")), new RegexLeaf("[%s]*"), new RegexLeaf("SECOND_LABEL", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("ENT2", "(?:" + CommandLinkClass.optionalKeywords(umlDiagramType) + "[%s]+)?" + CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE2", "\\([%s]*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)[%s]*,[%s]*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)[%s]*\\)")), new RegexLeaf("[%s]*"), CommandLinkClass.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL_LINK", "(?::[%s]*(.+))?"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private static String getClassIdentifier() {
        return "(" + CommandLinkClass.getSeparator() + "?[\\p{L}0-9_$]+(?:" + CommandLinkClass.getSeparator() + "[\\p{L}0-9_$]+)*|[%g][^%g]+[%g])";
    }

    private static String getSeparator() {
        return "(?:\\.|::)";
    }

    private static String optionalKeywords(UmlDiagramType umlDiagramType) {
        if (umlDiagramType == UmlDiagramType.CLASS) {
            return "(interface|enum|annotation|abstract[%s]+class|abstract|class|object)";
        }
        if (umlDiagramType == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    private LeafType getTypeIfObject(String string) {
        if ("object".equalsIgnoreCase(string)) {
            return LeafType.OBJECT;
        }
        return null;
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        Object object;
        Object object2;
        Object object3;
        IEntity iEntity;
        Code code = Code.of(regexResult.get("ENT1", 1));
        Code code2 = Code.of(regexResult.get("ENT2", 1));
        if (code == null) {
            return this.executeArgSpecial1(abstractClassOrObjectDiagram, regexResult);
        }
        if (code2 == null) {
            return this.executeArgSpecial2(abstractClassOrObjectDiagram, regexResult);
        }
        code = code.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        code2 = code2.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        if (abstractClassOrObjectDiagram.isGroup(code) && abstractClassOrObjectDiagram.isGroup(code2)) {
            return this.executePackageLink(abstractClassOrObjectDiagram, regexResult);
        }
        String string = regexResult.get("ENT1", 0);
        LeafType leafType = this.getTypeIfObject(string);
        IEntity iEntity2 = abstractClassOrObjectDiagram.isGroup(code) ? abstractClassOrObjectDiagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT1", 1), "\""))) : abstractClassOrObjectDiagram.getOrCreateLeaf(code, leafType, null);
        String string2 = regexResult.get("ENT2", 0);
        LeafType leafType2 = this.getTypeIfObject(string2);
        if (!abstractClassOrObjectDiagram.leafExist(code2) && iEntity2.getEntityType() == LeafType.OBJECT && leafType2 == null) {
            leafType2 = LeafType.OBJECT;
        }
        IEntity iEntity3 = iEntity = abstractClassOrObjectDiagram.isGroup(code2) ? abstractClassOrObjectDiagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT2", 1), "\""))) : abstractClassOrObjectDiagram.getOrCreateLeaf(code2, leafType2, null);
        if (regexResult.get("ENT1", 0) != null && (object3 = LeafType.getLeafType(regexResult.get("ENT1", 0))) != LeafType.OBJECT) {
            ((ILeaf)iEntity2).muteToType((LeafType)((Object)object3), null);
        }
        if (regexResult.get("ENT2", 0) != null && (object3 = LeafType.getLeafType(regexResult.get("ENT2", 0))) != LeafType.OBJECT) {
            ((ILeaf)iEntity).muteToType((LeafType)((Object)object3), null);
        }
        object3 = CommandLinkClass.color().getColor(regexResult, abstractClassOrObjectDiagram.getSkinParam().getIHtmlColorSet());
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : this.getQueueLength(regexResult);
        String string3 = regexResult.get("FIRST_LABEL", 0);
        String string4 = regexResult.get("SECOND_LABEL", 0);
        String string5 = null;
        if (regexResult.get("LABEL_LINK", 0) != null) {
            string5 = regexResult.get("LABEL_LINK", 0);
            if (string3 == null && string4 == null) {
                object2 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)[%g]([^%g]+)[%g]$");
                object = ((Pattern)object2).matcher(string5);
                if (((Matcher)object).matches()) {
                    string3 = ((Matcher)object).group(1);
                    string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(((Matcher)object).group(2)), "\""));
                    string4 = ((Matcher)object).group(3);
                } else {
                    Pattern pattern = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)$");
                    Matcher matcher = pattern.matcher(string5);
                    if (matcher.matches()) {
                        string3 = matcher.group(1);
                        string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher.group(2)), "\""));
                        string4 = null;
                    } else {
                        Pattern pattern2 = MyPattern.cmpile("^([^%g]+)[%g]([^%g]+)[%g]$");
                        Matcher matcher2 = pattern2.matcher(string5);
                        if (matcher2.matches()) {
                            string3 = null;
                            string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher2.group(1)), "\""));
                            string4 = matcher2.group(2);
                        }
                    }
                }
            }
            string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5, "\"");
        }
        object2 = LinkArrow.NONE;
        if ("<".equals(string5)) {
            object2 = LinkArrow.BACKWARD;
            string5 = null;
        } else if (">".equals(string5)) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string5 = null;
        } else if (string5 != null && string5.startsWith("< ")) {
            object2 = LinkArrow.BACKWARD;
            string5 = StringUtils.trin(string5.substring(2));
        } else if (string5 != null && string5.startsWith("> ")) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string5 = StringUtils.trin(string5.substring(2));
        } else if (string5 != null && string5.endsWith(" >")) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string5 = StringUtils.trin(string5.substring(0, string5.length() - 2));
        } else if (string5 != null && string5.endsWith(" <")) {
            object2 = LinkArrow.BACKWARD;
            string5 = StringUtils.trin(string5.substring(0, string5.length() - 2));
        }
        object = new Link(iEntity2, iEntity, linkType, Display.getWithNewlines(string5), n, string3, string4, abstractClassOrObjectDiagram.getLabeldistance(), abstractClassOrObjectDiagram.getLabelangle());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            object = ((Link)object).getInv();
        }
        ((Link)object).setLinkArrow((LinkArrow)((Object)object2));
        object3 = CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), (Link)object, (Colors)object3);
        ((Link)object).setColors((Colors)object3);
        this.addLink(abstractClassOrObjectDiagram, (Link)object, regexResult.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private void addLink(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, Link link, String string) {
        abstractClassOrObjectDiagram.addLink(link);
        if (string != null) {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private CommandExecutionResult executePackageLink(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        IGroup iGroup = abstractClassOrObjectDiagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT1", 1), "\"")));
        IGroup iGroup2 = abstractClassOrObjectDiagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT2", 1), "\"")));
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : this.getQueueLength(regexResult);
        Colors colors = CommandLinkClass.color().getColor(regexResult, abstractClassOrObjectDiagram.getSkinParam().getIHtmlColorSet());
        Display display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0));
        String string = regexResult.get("FIRST_LABEL", 0);
        String string2 = regexResult.get("SECOND_LABEL", 0);
        Link link = new Link(iGroup, iGroup2, linkType, display, n, string, string2, abstractClassOrObjectDiagram.getLabeldistance(), abstractClassOrObjectDiagram.getLabelangle());
        abstractClassOrObjectDiagram.resetPragmaLabel();
        colors = CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), link, colors);
        link.setColors(colors);
        this.addLink(abstractClassOrObjectDiagram, link, regexResult.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        Display display;
        LinkType linkType;
        Code code = Code.of(regexResult.get("COUPLE1", 0));
        Code code2 = Code.of(regexResult.get("COUPLE1", 1));
        if (!abstractClassOrObjectDiagram.leafExist(code)) {
            return CommandExecutionResult.error("No class " + code);
        }
        if (!abstractClassOrObjectDiagram.leafExist(code2)) {
            return CommandExecutionResult.error("No class " + code2);
        }
        Code code3 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT2", 1), "\""));
        IEntity iEntity = abstractClassOrObjectDiagram.getOrCreateLeaf(code3, null, null);
        boolean bl = abstractClassOrObjectDiagram.associationClass(1, code, code2, iEntity, linkType = this.getLinkType(regexResult), display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0)));
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial2(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        Display display;
        LinkType linkType;
        Code code = Code.of(regexResult.get("COUPLE2", 0));
        Code code2 = Code.of(regexResult.get("COUPLE2", 1));
        if (!abstractClassOrObjectDiagram.leafExist(code)) {
            return CommandExecutionResult.error("No class " + code);
        }
        if (!abstractClassOrObjectDiagram.leafExist(code2)) {
            return CommandExecutionResult.error("No class " + code2);
        }
        Code code3 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT1", 1), "\""));
        IEntity iEntity = abstractClassOrObjectDiagram.getOrCreateLeaf(code3, null, null);
        boolean bl = abstractClassOrObjectDiagram.associationClass(2, code, code2, iEntity, linkType = this.getLinkType(regexResult), display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0)));
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private LinkDecor getDecors1(String string) {
        if (string == null) {
            return LinkDecor.NONE;
        }
        if ("<|".equals(string = StringUtils.trin(string))) {
            return LinkDecor.EXTENDS;
        }
        if ("<".equals(string)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(string)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(string)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(string)) {
            return LinkDecor.AGREGATION;
        }
        if ("*".equals(string)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(string)) {
            return LinkDecor.SQUARRE;
        }
        return LinkDecor.NONE;
    }

    private LinkDecor getDecors2(String string) {
        if (string == null) {
            return LinkDecor.NONE;
        }
        if ("|>".equals(string = StringUtils.trin(string))) {
            return LinkDecor.EXTENDS;
        }
        if (">".equals(string)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(string)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(string)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(string)) {
            return LinkDecor.AGREGATION;
        }
        if ("*".equals(string)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(string)) {
            return LinkDecor.SQUARRE;
        }
        return LinkDecor.NONE;
    }

    private LinkType getLinkType(RegexResult regexResult) {
        String string;
        LinkDecor linkDecor = this.getDecors1(regexResult.get("ARROW_HEAD1", 0));
        LinkDecor linkDecor2 = this.getDecors2(regexResult.get("ARROW_HEAD2", 0));
        LinkType linkType = new LinkType(linkDecor2, linkDecor);
        if (regexResult.get("ARROW_BODY1", 0).contains(".") || regexResult.get("ARROW_BODY2", 0).contains(".")) {
            linkType = linkType.getDashed();
        }
        if ("0".equals(string = regexResult.get("INSIDE", 0))) {
            linkType = linkType.withMiddleCircle();
        } else if ("0)".equals(string)) {
            linkType = linkType.withMiddleCircleCircled1();
        } else if ("(0".equals(string)) {
            linkType = linkType.withMiddleCircleCircled2();
        } else if ("(0)".equals(string)) {
            linkType = linkType.withMiddleCircleCircled();
        }
        return linkType;
    }

    private int getQueueLength(RegexResult regexResult) {
        String string = this.getFullArrow(regexResult);
        string = string.replaceAll("[^-.=]", "");
        return string.length();
    }

    private Direction getDirection(RegexResult regexResult) {
        LinkDecor linkDecor = this.getDecors1(regexResult.get("ARROW_HEAD1", 0));
        LinkDecor linkDecor2 = this.getDecors2(regexResult.get("ARROW_HEAD2", 0));
        String string = this.getFullArrow(regexResult);
        if ((string = string.replaceAll("[^-.=\\w]", "")).startsWith("o")) {
            string = string.substring(1);
        }
        if (string.endsWith("o")) {
            string = string.substring(0, string.length() - 1);
        }
        Direction direction = StringUtils.getQueueDirection(string);
        if (this.isInversed(linkDecor, linkDecor2) && string.matches(".*\\w.*")) {
            direction = direction.getInv();
        }
        return direction;
    }

    private String getFullArrow(RegexResult regexResult) {
        return CommandLinkClass.notNull(regexResult.get("ARROW_HEAD1", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_BODY1", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_DIRECTION", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_BODY2", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_HEAD2", 0));
    }

    public static String notNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    @Deprecated
    public static Colors applyStyle(String string, Link link) {
        return CommandLinkClass.applyStyle(string, link, null);
    }

    public static Colors applyStyle(String string, Link link, Colors colors) {
        if (string == null) {
            return colors;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dashed")) {
                link.goDashed();
                continue;
            }
            if (string2.equalsIgnoreCase("bold")) {
                link.goBold();
                continue;
            }
            if (string2.equalsIgnoreCase("dotted")) {
                link.goDotted();
                continue;
            }
            if (string2.equalsIgnoreCase("hidden")) {
                link.goHidden();
                continue;
            }
            if (string2.equalsIgnoreCase("norank")) {
                link.goNorank();
                continue;
            }
            link.setSpecificColor(string2);
            if (colors == null) continue;
            colors = colors.add(ColorType.LINE, HtmlColorSet.getInstance().getColorIfValid(string2));
        }
        return colors;
    }

    private boolean isInversed(LinkDecor linkDecor, LinkDecor linkDecor2) {
        if (linkDecor == LinkDecor.ARROW && linkDecor2 != LinkDecor.ARROW) {
            return true;
        }
        if (linkDecor2 == LinkDecor.AGREGATION) {
            return true;
        }
        if (linkDecor2 == LinkDecor.COMPOSITION) {
            return true;
        }
        return linkDecor2 == LinkDecor.PLUS;
    }
}

