/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkLollipop
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkLollipop(UmlDiagramType umlDiagramType) {
        super(CommandLinkLollipop.getRegexConcat(umlDiagramType));
    }

    static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)[%s]+)?"), new RegexLeaf("ENT1", "(?:" + CommandLinkLollipop.optionalKeywords(umlDiagramType) + "[%s]+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|[%g][^%g]+[%g])[%s]*(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("FIRST_LABEL", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("LOL_THEN_ENT", "\\(\\)([-=.]+)"), new RegexLeaf("ENT_THEN_LOL", "([-=.]+)\\(\\)")), new RegexLeaf("[%s]*"), new RegexLeaf("SECOND_LABEL", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexLeaf("ENT2", "(?:" + CommandLinkLollipop.optionalKeywords(umlDiagramType) + "[%s]+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|[%g][^%g]+[%g])[%s]*(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL_LINK", "(?::[%s]*(.+))?"), new RegexLeaf("$"));
    }

    private static String optionalKeywords(UmlDiagramType umlDiagramType) {
        if (umlDiagramType == UmlDiagramType.CLASS) {
            return "(interface|enum|annotation|abstract[%s]+class|abstract|class)";
        }
        if (umlDiagramType == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        Object object;
        IEntity iEntity;
        IEntity iEntity2;
        IEntity iEntity3;
        Code code = Code.of(regexResult.get("ENT1", 1));
        Code code2 = Code.of(regexResult.get("ENT2", 1));
        String string = "lol" + UniqueSequence.getValue();
        if (regexResult.get("LOL_THEN_ENT", 0) == null) {
            assert (regexResult.get("ENT_THEN_LOL", 0) != null);
            iEntity3 = abstractClassOrObjectDiagram.getOrCreateLeaf(code, null, null);
            iEntity2 = abstractClassOrObjectDiagram.createLeaf(iEntity3.getCode().addSuffix(string), Display.getWithNewlines(code2), LeafType.LOLLIPOP, null);
            iEntity = iEntity3;
        } else {
            iEntity2 = abstractClassOrObjectDiagram.getOrCreateLeaf(code2, null, null);
            iEntity3 = abstractClassOrObjectDiagram.createLeaf(iEntity2.getCode().addSuffix(string), Display.getWithNewlines(code), LeafType.LOLLIPOP, null);
            iEntity = iEntity2;
        }
        LinkType linkType = this.getLinkType(regexResult);
        String string2 = this.getQueue(regexResult);
        int n = string2.length();
        if (n == 1 && abstractClassOrObjectDiagram.getNbOfHozizontalLollipop(iEntity) > 1) {
            ++n;
        }
        String string3 = regexResult.get("FIRST_LABEL", 0);
        String string4 = regexResult.get("SECOND_LABEL", 0);
        String string5 = null;
        if (regexResult.get("LABEL_LINK", 0) != null) {
            string5 = regexResult.get("LABEL_LINK", 0);
            if (string3 == null && string4 == null) {
                object = MyPattern.cmpile("^\"([^\"]+)\"([^\"]+)\"([^\"]+)\"$");
                Matcher matcher = ((Pattern)object).matcher(string5);
                if (matcher.matches()) {
                    string3 = matcher.group(1);
                    string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher.group(2))));
                    string4 = matcher.group(3);
                } else {
                    Pattern pattern = MyPattern.cmpile("^\"([^\"]+)\"([^\"]+)$");
                    Matcher matcher2 = pattern.matcher(string5);
                    if (matcher2.matches()) {
                        string3 = matcher2.group(1);
                        string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher2.group(2))));
                        string4 = null;
                    } else {
                        Pattern pattern2 = MyPattern.cmpile("^([^\"]+)\"([^\"]+)\"$");
                        Matcher matcher3 = pattern2.matcher(string5);
                        if (matcher3.matches()) {
                            string3 = null;
                            string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher3.group(1))));
                            string4 = matcher3.group(2);
                        }
                    }
                }
            }
            string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5);
        }
        object = new Link(iEntity3, iEntity2, linkType, Display.getWithNewlines(string5), n, string3, string4, abstractClassOrObjectDiagram.getLabeldistance(), abstractClassOrObjectDiagram.getLabelangle());
        abstractClassOrObjectDiagram.resetPragmaLabel();
        this.addLink(abstractClassOrObjectDiagram, (Link)object, regexResult.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private void addLink(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, Link link, String string) {
        abstractClassOrObjectDiagram.addLink(link);
        if (string != null) {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private LinkType getLinkType(RegexResult regexResult) {
        return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
    }

    private String getQueue(RegexResult regexResult) {
        if (regexResult.get("LOL_THEN_ENT", 0) != null) {
            return StringUtils.trin(regexResult.get("LOL_THEN_ENT", 0));
        }
        if (regexResult.get("ENT_THEN_LOL", 0) != null) {
            return StringUtils.trin(regexResult.get("ENT_THEN_LOL", 0));
        }
        throw new IllegalArgumentException();
    }
}

