/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorySequenceNoteCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("VMERGE", "(/)?[%s]*"), new RegexLeaf("STYLE", "(note|hnote|rnote)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), new RegexLeaf("[%s]*"), new RegexLeaf("POSITION", "(right|left|over)[%s]+"), new RegexLeaf("PARTICIPANT", "(?:of[%s]+)?([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*"), FactorySequenceNoteCommand.color().getRegex(), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("VMERGE", "(/)?[%s]*"), new RegexLeaf("STYLE", "(note|hnote|rnote)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), new RegexLeaf("[%s]*"), new RegexLeaf("POSITION", "(right|left|over)[%s]+"), new RegexLeaf("PARTICIPANT", "(?:of[%s])?([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*"), FactorySequenceNoteCommand.color().getRegex(), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean bl) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?(note|hnote|rnote)$";
            }

            @Override
            public CommandExecutionResult executeNow(SequenceDiagram sequenceDiagram, BlocLines blocLines) {
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                return FactorySequenceNoteCommand.this.executeInternal(sequenceDiagram, regexResult, blocLines);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
                return FactorySequenceNoteCommand.this.executeInternal(sequenceDiagram, regexResult, BlocLines.getWithNewlines(regexResult.get("NOTE", 0)));
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram sequenceDiagram, RegexResult regexResult, BlocLines blocLines) {
        Participant participant = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("PARTICIPANT", 0)));
        NotePosition notePosition = NotePosition.valueOf(StringUtils.goUpperCase(regexResult.get("POSITION", 0)));
        if (blocLines.size() > 0) {
            boolean bl = regexResult.get("VMERGE", 0) != null;
            Note note = new Note(participant, notePosition, blocLines.toDisplay());
            Colors colors = FactorySequenceNoteCommand.color().getColor(regexResult, sequenceDiagram.getSkinParam().getIHtmlColorSet());
            String string = regexResult.get("STEREO", 0);
            if (string != null) {
                Stereotype stereotype = new Stereotype(string);
                note.setStereotype(stereotype);
                colors = colors.applyStereotypeForNote(stereotype, sequenceDiagram.getSkinParam(), FontParam.NOTE, ColorParam.noteBackground, ColorParam.noteBorder);
            }
            note.setColors(colors);
            note.setStyle(NoteStyle.getNoteStyle(regexResult.get("STYLE", 0)));
            sequenceDiagram.addNote(note, bl);
        }
        return CommandExecutionResult.ok();
    }
}

