/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorySequenceNoteOnArrowCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left)[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left)[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(sequenceDiagram, regexResult, BlocLines.getWithNewlines(regexResult.get("NOTE", 0)));
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean bl) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^[%s]*end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(SequenceDiagram sequenceDiagram, BlocLines blocLines) {
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(sequenceDiagram, regexResult, blocLines);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram sequenceDiagram, RegexResult regexResult, BlocLines blocLines) {
        EventWithDeactivate eventWithDeactivate = sequenceDiagram.getLastEventWithDeactivate();
        if (eventWithDeactivate instanceof AbstractMessage) {
            Url url;
            NotePosition notePosition = NotePosition.valueOf(StringUtils.goUpperCase(regexResult.get("POSITION", 0)));
            if (blocLines.size() > 0) {
                UrlBuilder urlBuilder = new UrlBuilder(sequenceDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                url = urlBuilder.getUrl(blocLines.getFirst499().toString());
            } else {
                url = null;
            }
            if (url != null) {
                blocLines = blocLines.subExtract(1, 0);
            }
            ((AbstractMessage)eventWithDeactivate).setNote(blocLines.toDisplay(), notePosition, regexResult.get("COLOR", 0), url);
        }
        return CommandExecutionResult.ok();
    }
}

