/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;
import net.sourceforge.plantuml.version.IteratorCounter2Impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UmlSource {
    private final List<String> source;
    private final List<CharSequence2> source2;

    public UmlSource(List<CharSequence2> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<CharSequence2> arrayList2 = new ArrayList<CharSequence2>();
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (CharSequence2 charSequence2 : list) {
                String string = charSequence2.toString2();
                if (StringUtils.endsWithBackslash(string)) {
                    stringBuilder.append(string.substring(0, string.length() - 1));
                    continue;
                }
                stringBuilder.append(string);
                arrayList.add(stringBuilder.toString());
                arrayList2.add(new CharSequence2Impl(stringBuilder.toString(), charSequence2.getLocation()));
                stringBuilder.setLength(0);
            }
        } else {
            for (CharSequence2 charSequence2 : list) {
                arrayList.add(charSequence2.toString2());
                arrayList2.add(charSequence2);
            }
        }
        this.source = Collections.unmodifiableList(arrayList);
        this.source2 = Collections.unmodifiableList(arrayList2);
    }

    public DiagramType getDiagramType() {
        return DiagramType.getTypeFromArobaseStart(this.source.get(0));
    }

    public IteratorCounter2 iterator2() {
        return new IteratorCounter2Impl(this.source2);
    }

    public String getPlainString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.source) {
            stringBuilder.append(string);
            stringBuilder.append('\r');
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String getLine(int n) {
        return this.source.get(n);
    }

    public int getTotalLineCount() {
        return this.source.size();
    }

    public boolean isEmpty() {
        for (String string : this.source) {
            if (StartUtils.isArobaseStartDiagram(string) || StartUtils.isArobaseEndDiagram(string) || string.matches("\\s*'.*") || StringUtils.trin(string).length() == 0) continue;
            return false;
        }
        return true;
    }

    public Display getTitle() {
        Pattern pattern = MyPattern.cmpile("(?i)^[%s]*title[%s]+(.+)$");
        for (String string : this.source) {
            Matcher matcher = pattern.matcher(string);
            boolean bl = matcher.matches();
            if (!bl) continue;
            return Display.create(matcher.group(1));
        }
        return Display.empty();
    }
}

