/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockSpotted;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Display
implements Iterable<CharSequence> {
    private final List<CharSequence> display;
    private final HorizontalAlignment naturalHorizontalAlignment;
    private final boolean isNull;
    private final CreoleMode defaultCreoleMode;
    public static final Display NULL = new Display(null, null, true, CreoleMode.FULL);

    public Display removeUrlHiddenNewLineUrl() {
        String string = UrlBuilder.purgeUrl(this.asStringWithHiddenNewLine());
        return new Display(StringUtils.splitHiddenNewLine(string), this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public boolean isWhite() {
        return this.display.size() == 0 || this.display.size() == 1 && this.display.get(0).toString().matches("\\s*");
    }

    public static Display empty() {
        return new Display(null, false, CreoleMode.FULL);
    }

    public static Display create(CharSequence ... charSequenceArray) {
        return Display.create(Arrays.asList(charSequenceArray));
    }

    public static Display create(Collection<? extends CharSequence> collection) {
        return new Display(collection, null, false, CreoleMode.FULL);
    }

    public static Display getWithNewlines(Code code) {
        return Display.getWithNewlines(code.getFullName());
    }

    public static Display getWithNewlines(String string) {
        if (string == null) {
            return NULL;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        HorizontalAlignment horizontalAlignment = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < string.length() - 1) {
                char c2 = string.charAt(i + 1);
                ++i;
                if (c2 == 'n' || c2 == 'r' || c2 == 'l') {
                    if (c2 == 'r') {
                        horizontalAlignment = HorizontalAlignment.RIGHT;
                    } else if (c2 == 'l') {
                        horizontalAlignment = HorizontalAlignment.LEFT;
                    }
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                if (c2 == '\\') {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append(c);
                stringBuilder.append(c2);
                continue;
            }
            if (c == StringUtils.hiddenNewLine()) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString());
        return new Display(arrayList, horizontalAlignment, false, CreoleMode.FULL);
    }

    private Display(Display display, CreoleMode creoleMode) {
        this(display.naturalHorizontalAlignment, display.isNull, creoleMode);
        this.display.addAll(display.display);
    }

    private Display(HorizontalAlignment horizontalAlignment, boolean bl, CreoleMode creoleMode) {
        this.defaultCreoleMode = creoleMode;
        this.isNull = bl;
        this.display = bl ? null : new ArrayList();
        this.naturalHorizontalAlignment = bl ? null : horizontalAlignment;
    }

    private Display(Collection<? extends CharSequence> collection, HorizontalAlignment horizontalAlignment, boolean bl, CreoleMode creoleMode) {
        this(horizontalAlignment, bl, creoleMode);
        if (!bl) {
            this.display.addAll(Display.manageEmbededDiagrams2(collection));
        }
    }

    private static List<CharSequence> manageEmbededDiagrams2(Collection<? extends CharSequence> collection) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        Iterator<? extends CharSequence> iterator = collection.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence = iterator.next();
            if (charSequence != null && StringUtils.trin(charSequence.toString()).equals("{{")) {
                CharSequence charSequence2;
                ArrayList<CharSequence> arrayList2 = new ArrayList<CharSequence>();
                arrayList2.add("@startuml");
                while (iterator.hasNext() && ((charSequence2 = iterator.next()) == null || !StringUtils.trin(charSequence2.toString()).equals("}}"))) {
                    arrayList2.add(charSequence2);
                }
                arrayList2.add("@enduml");
                charSequence = new EmbededDiagram(Display.create(arrayList2));
            }
            arrayList.add(charSequence);
        }
        return arrayList;
    }

    public Display underlined() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CharSequence charSequence : this.display) {
            arrayList.add("<u>" + charSequence);
        }
        return new Display(arrayList, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withCreoleMode(CreoleMode creoleMode) {
        if (this.isNull) {
            throw new IllegalArgumentException();
        }
        return new Display(this, creoleMode);
    }

    public String asStringWithHiddenNewLine() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.display.size(); ++i) {
            stringBuilder.append(this.display.get(i));
            if (i >= this.display.size() - 1) continue;
            stringBuilder.append(StringUtils.hiddenNewLine());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.isNull) {
            return "NULL";
        }
        return this.display.toString();
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object object) {
        return this.display.equals(((Display)object).display);
    }

    public Display addAll(Display display) {
        Display display2 = new Display(this, this.defaultCreoleMode);
        display2.display.addAll(display.display);
        return display2;
    }

    public Display addFirst(CharSequence charSequence) {
        Display display = new Display(this, this.defaultCreoleMode);
        display.display.add(0, charSequence);
        return display;
    }

    public Display add(CharSequence charSequence) {
        Display display = new Display(this, this.defaultCreoleMode);
        display.display.add(charSequence);
        return display;
    }

    public int size() {
        if (this.isNull) {
            return 0;
        }
        return this.display.size();
    }

    public CharSequence get(int n) {
        return this.display.get(n);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Collections.unmodifiableList(this.display).iterator();
    }

    public Display subList(int n, int n2) {
        return new Display(this.display.subList(n, n2), this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public List<? extends CharSequence> as() {
        return Collections.unmodifiableList(this.display);
    }

    public List<CharSequence2> as2() {
        ArrayList<CharSequence2Impl> arrayList = new ArrayList<CharSequence2Impl>();
        LineLocationImpl lineLocationImpl = new LineLocationImpl("inner", null);
        for (CharSequence charSequence : this.display) {
            lineLocationImpl = lineLocationImpl.oneLineRead();
            arrayList.add(new CharSequence2Impl(charSequence, lineLocationImpl));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Url initUrl() {
        if (this.size() == 0) {
            return null;
        }
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.AT_START);
        return urlBuilder.getUrl(StringUtils.trin(this.get(0).toString()));
    }

    public Display removeUrl(Url url) {
        if (url == null) {
            return this;
        }
        Display display = new Display(this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        display.display.add(UrlBuilder.purgeUrl(this.get(0).toString()));
        display.display.addAll(this.subList((int)1, (int)this.size()).display);
        return display;
    }

    public boolean hasUrl() {
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.ANYWHERE);
        for (CharSequence charSequence : this) {
            if (urlBuilder.getUrl(charSequence.toString()) == null) continue;
            return true;
        }
        return false;
    }

    public HorizontalAlignment getNaturalHorizontalAlignment() {
        return this.naturalHorizontalAlignment;
    }

    public List<Display> splitMultiline(Pattern pattern) {
        ArrayList<Display> arrayList = new ArrayList<Display>();
        Display display = new Display(this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        arrayList.add(display);
        for (CharSequence charSequence : this.display) {
            Matcher matcher = pattern.matcher(charSequence);
            if (matcher.find()) {
                CharSequence charSequence2 = charSequence.subSequence(0, matcher.start());
                display.display.add(charSequence2);
                CharSequence charSequence3 = charSequence.subSequence(matcher.end(), charSequence.length());
                display = new Display(this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
                arrayList.add(display);
                display.display.add(charSequence3);
                continue;
            }
            display.display.add(charSequence);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static boolean isNull(Display display) {
        return display == null || display.isNull;
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple) {
        return this.create(fontConfiguration, horizontalAlignment, iSkinSimple, CreoleMode.FULL);
    }

    public TextBlock createWithNiceCreoleMode(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple) {
        return this.create(fontConfiguration, horizontalAlignment, iSkinSimple, this.defaultCreoleMode);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, CreoleMode creoleMode) {
        return this.create(fontConfiguration, horizontalAlignment, iSkinSimple, 0.0, creoleMode, null, null);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d, CreoleMode creoleMode, UFont uFont, HtmlColor htmlColor) {
        if (this.getNaturalHorizontalAlignment() != null) {
            horizontalAlignment = this.getNaturalHorizontalAlignment();
        }
        if (this.size() > 0) {
            if (this.get(0) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, iSkinSimple, 0, uFont, htmlColor);
            }
            if (this.get(this.size() - 1) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, iSkinSimple, this.size() - 1, uFont, htmlColor);
            }
            if (this.get(0) instanceof MessageNumber) {
                return this.createMessageNumber(fontConfiguration, horizontalAlignment, iSkinSimple, d);
            }
        }
        return this.getCreole(fontConfiguration, horizontalAlignment, iSkinSimple, d, creoleMode);
    }

    private TextBlock getCreole(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d, CreoleMode creoleMode) {
        Sheet sheet = new CreoleParser(fontConfiguration, horizontalAlignment, iSkinSimple, creoleMode).createSheet(this);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, d, iSkinSimple == null ? 0.0 : iSkinSimple.getPadding());
        return new SheetBlock2(sheetBlock1, sheetBlock1, new UStroke(1.5));
    }

    private TextBlock createMessageNumber(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d) {
        TextBlock textBlock = this.subList(0, 1).getCreole(fontConfiguration, horizontalAlignment, iSkinSimple, d, CreoleMode.FULL);
        textBlock = TextBlockUtils.withMargin(textBlock, 0.0, 4.0, 0.0, 0.0);
        TextBlock textBlock2 = this.subList(1, this.size()).getCreole(fontConfiguration, horizontalAlignment, iSkinSimple, d, CreoleMode.FULL);
        return TextBlockUtils.mergeLR(textBlock, textBlock2, VerticalAlignment.CENTER);
    }

    private TextBlock createStereotype(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, int n, UFont uFont, HtmlColor htmlColor) {
        Stereotype stereotype = (Stereotype)this.get(n);
        if (stereotype.isSpotted()) {
            CircledCharacter circledCharacter = new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor());
            if (stereotype.getLabel(false) == null) {
                return new TextBlockSpotted(circledCharacter, this.subList(1, this.size()), fontConfiguration, horizontalAlignment, spriteContainer);
            }
            return new TextBlockSpotted(circledCharacter, this, fontConfiguration, horizontalAlignment, spriteContainer);
        }
        return new TextBlockSimple(this, fontConfiguration, horizontalAlignment, spriteContainer, 0.0, uFont, htmlColor);
    }
}

