/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.AbstractPlacementStrategy;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyVisibility;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Center;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Left;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.utils.CharHidder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsOrFieldsArea
extends AbstractTextBlock
implements TextBlockWidth,
TextBlock {
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final HtmlColor color;
    private final HtmlColor hyperlinkColor;
    private final boolean useUnderlineForHyperlink;
    private final Rose rose = new Rose();
    private final List<Member> members = new ArrayList<Member>();
    private final HorizontalAlignment align;

    public TextBlock asBlockMemberImpl() {
        return new TextBlockLineBefore(TextBlockUtils.withMargin(this, 6.0, 4.0));
    }

    public MethodsOrFieldsArea(List<Member> list, FontParam fontParam, ISkinParam iSkinParam) {
        this(list, fontParam, iSkinParam, HorizontalAlignment.LEFT);
    }

    public MethodsOrFieldsArea(List<Member> list, FontParam fontParam, ISkinParam iSkinParam, HorizontalAlignment horizontalAlignment) {
        this.align = horizontalAlignment;
        this.skinParam = iSkinParam;
        this.fontParam = fontParam;
        this.color = this.rose.getFontColor(iSkinParam, fontParam);
        this.hyperlinkColor = iSkinParam.getHyperlinkColor();
        this.useUnderlineForHyperlink = iSkinParam.useUnderlineForHyperlink();
        this.members.addAll(list);
    }

    private boolean hasSmallIcon() {
        if (this.skinParam.classAttributeIconSize() == 0) {
            return false;
        }
        for (Member member : this.members) {
            if (member.getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        if (this.hasSmallIcon()) {
            d = this.skinParam.getCircledCharacterRadius() + 3;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (Member member : this.members) {
            TextBlock textBlock = this.createTextBlock(member);
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            d2 = Math.max(dimension2D.getWidth(), d2);
            d3 += dimension2D.getHeight();
        }
        return new Dimension2DDouble(d2 += d, d3);
    }

    private TextBlock createTextBlock(Member member) {
        boolean bl = this.skinParam.classAttributeIconSize() == 0;
        String string = member.getDisplay(bl);
        if (bl && string.startsWith("#")) {
            string = CharHidder.addTileAtBegin(string);
        }
        FontConfiguration fontConfiguration = new FontConfiguration(this.skinParam, this.fontParam, null);
        if (member.isAbstract()) {
            fontConfiguration = fontConfiguration.italic();
        }
        if (member.isStatic()) {
            fontConfiguration = fontConfiguration.underline();
        }
        TextBlock textBlock = Display.getWithNewlines(string).create(fontConfiguration, this.align, this.skinParam, CreoleMode.SIMPLE_LINE);
        textBlock = TextBlockUtils.fullInnerPosition(textBlock, member.getDisplay(false));
        return new TextBlockTracer(member, textBlock);
    }

    private TextBlock getUBlock(VisibilityModifier visibilityModifier) {
        if (visibilityModifier == null) {
            return new AbstractTextBlock(){

                public void drawU(UGraphic uGraphic) {
                }

                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return new Dimension2DDouble(1.0, 1.0);
                }
            };
        }
        HtmlColor htmlColor = visibilityModifier.getBackground() == null ? null : this.rose.getHtmlColor(this.skinParam, visibilityModifier.getBackground());
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.skinParam, visibilityModifier.getForeground());
        TextBlock textBlock = visibilityModifier.getUBlock(this.skinParam.classAttributeIconSize(), htmlColor2, htmlColor);
        return textBlock;
    }

    @Override
    public TextBlock asTextBlock(double d) {
        return this;
    }

    public boolean contains(String string) {
        for (Member member : this.members) {
            if (!member.getDisplay(false).startsWith(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle2D getInnerPosition(String string, StringBounder stringBounder) {
        ULayoutGroup uLayoutGroup = this.getLayout(stringBounder);
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        return uLayoutGroup.getInnerPosition(string, dimension2D.getWidth(), dimension2D.getHeight(), stringBounder);
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup uLayoutGroup;
        if (this.hasSmallIcon()) {
            uLayoutGroup = new ULayoutGroup(new PlacementStrategyVisibility(stringBounder, this.skinParam.getCircledCharacterRadius() + 3));
            for (Member member : this.members) {
                TextBlock textBlock = this.createTextBlock(member);
                VisibilityModifier visibilityModifier = member.getVisibilityModifier();
                uLayoutGroup.add(this.getUBlock(visibilityModifier));
                uLayoutGroup.add(textBlock);
            }
        } else {
            AbstractPlacementStrategy abstractPlacementStrategy;
            if (this.align == HorizontalAlignment.LEFT) {
                abstractPlacementStrategy = new PlacementStrategyY1Y2Left(stringBounder);
            } else if (this.align == HorizontalAlignment.CENTER) {
                abstractPlacementStrategy = new PlacementStrategyY1Y2Center(stringBounder);
            } else {
                throw new IllegalStateException();
            }
            uLayoutGroup = new ULayoutGroup(abstractPlacementStrategy);
            for (Member member : this.members) {
                TextBlock textBlock = this.createTextBlock(member);
                uLayoutGroup.add(textBlock);
            }
        }
        return uLayoutGroup;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        ULayoutGroup uLayoutGroup = this.getLayout(uGraphic.getStringBounder());
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        uLayoutGroup.drawU(uGraphic, dimension2D.getWidth(), dimension2D.getHeight());
    }

    static class TextBlockTracer
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock bloc;
        private final Url url;

        public TextBlockTracer(Member member, TextBlock textBlock) {
            this.bloc = textBlock;
            this.url = member.getUrl();
        }

        public void drawU(UGraphic uGraphic) {
            if (this.url != null) {
                uGraphic.startUrl(this.url);
            }
            this.bloc.drawU(uGraphic);
            if (this.url != null) {
                uGraphic.closeAction();
            }
        }

        public Dimension2D calculateDimension(StringBounder stringBounder) {
            Dimension2D dimension2D = this.bloc.calculateDimension(stringBounder);
            return dimension2D;
        }

        public Rectangle2D getInnerPosition(String string, StringBounder stringBounder) {
            return this.bloc.getInnerPosition(string, stringBounder);
        }
    }
}

