/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graph.ANodeImpl;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.BoardExplorer;
import net.sourceforge.plantuml.graph.Graph5;
import net.sourceforge.plantuml.graph.Heap;
import net.sourceforge.plantuml.graph.Zoda2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramPngMaker3 {
    private final CucaDiagram diagram;

    public CucaDiagramPngMaker3(CucaDiagram cucaDiagram) {
        this.diagram = cucaDiagram;
    }

    public void createPng(OutputStream outputStream) throws IOException {
        Object object;
        Zoda2 zoda2 = new Zoda2();
        for (Link object22 : this.diagram.getLinks()) {
            object = object22.getEntity1().getCode() + "->" + object22.getEntity2().getCode();
            int n = object22.getLength() - 1;
            zoda2.addLink((String)object, n, object22);
        }
        for (IEntity iEntity : this.diagram.getLeafsvalues()) {
            object = zoda2.getNode(iEntity.getCode().getFullName());
            if (object == null) {
                object = zoda2.createAloneNode(iEntity.getCode().getFullName());
            }
            ((ANodeImpl)object).setUserData(iEntity);
        }
        List<Graph5> list = this.getGraphs3(zoda2.getHeaps());
        Dimension2D dimension2D = this.getTotalDimension(list);
        object = new EmptyImageBuilder(dimension2D.getWidth(), dimension2D.getHeight(), Color.WHITE);
        double d = 0.0;
        Graphics2D graphics2D = ((EmptyImageBuilder)object).getGraphics2D();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Graph5 graph5 = (Graph5)iterator.next();
            graphics2D.setTransform(new AffineTransform());
            graphics2D.translate(d, 0.0);
            graph5.draw(graphics2D);
            d += graph5.getDimension().getWidth();
        }
        ImageIO.write((RenderedImage)((EmptyImageBuilder)object).getBufferedImage(), "png", outputStream);
    }

    private Dimension2D getTotalDimension(List<Graph5> list) {
        double d = 0.0;
        double d2 = 0.0;
        for (Graph5 graph5 : list) {
            d += graph5.getDimension().getWidth();
            d2 = Math.max(d2, graph5.getDimension().getHeight());
        }
        return new Dimension2DDouble(d, d2);
    }

    private List<Graph5> getGraphs3(Collection<Heap> collection) {
        ArrayList<Graph5> arrayList = new ArrayList<Graph5>();
        for (Heap heap : collection) {
            boolean bl;
            heap.computeRows();
            Board board = new Board(heap.getNodes(), heap.getLinks());
            BoardExplorer boardExplorer = new BoardExplorer(board);
            long l = System.currentTimeMillis();
            for (int i = 0; i < 400 && !(bl = boardExplorer.onePass()); ++i) {
                if (i % 100 != 0) continue;
                Log.info("" + i + " boardExplorer.getBestCost()=" + boardExplorer.getBestCost() + " " + boardExplorer.collectionSize());
            }
            Log.info("################# DURATION = " + (System.currentTimeMillis() - l));
            board = boardExplorer.getBestBoard();
            arrayList.add(new Graph5(board));
        }
        return arrayList;
    }
}

