/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.Balloon;
import net.sourceforge.plantuml.cute.CuteShape;
import net.sourceforge.plantuml.cute.MyDouble;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.VarArgs;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

public class Cheese
implements CuteShape {
    private final MyDouble radius;
    private final MyDouble startAngle;
    private final MyDouble endAngle;
    private final RotationZoom rotationZoom;

    public Cheese(VarArgs varArgs) {
        this.radius = varArgs.getAsMyDouble("radius");
        this.startAngle = varArgs.getAsMyDouble("start").toRadians();
        this.endAngle = varArgs.getAsMyDouble("end").toRadians();
        this.rotationZoom = RotationZoom.none();
    }

    public Cheese(MyDouble myDouble, MyDouble myDouble2, MyDouble myDouble3, RotationZoom rotationZoom) {
        this.radius = myDouble;
        this.startAngle = myDouble2;
        this.endAngle = myDouble3;
        this.rotationZoom = rotationZoom;
    }

    public void drawU(UGraphic uGraphic) {
        Point2D point2D;
        Object object;
        Point2D point2D2;
        Balloon balloon = new Balloon(new Point2D.Double(), this.radius.getValue()).rotate(this.rotationZoom);
        double d = this.rotationZoom.applyRotation(this.startAngle.getValue());
        double d2 = this.rotationZoom.applyRotation(this.endAngle.getValue());
        Point2D point2D3 = balloon.getPointOnCircle(d);
        Point2D point2D4 = balloon.getPointOnCircle(d2);
        UPath uPath = new UPath();
        if (this.radius.hasCurvation()) {
            point2D2 = balloon.getSegmentCenterToPointOnCircle(d).getFromAtoB(this.radius.getCurvation(0.0));
            uPath.moveTo(point2D2);
        } else {
            point2D2 = null;
            uPath.moveTo(balloon.getCenter());
        }
        if (this.startAngle.hasCurvation()) {
            Balloon balloon2 = balloon.getInsideTangentBalloon1(d, this.startAngle.getCurvation(0.0));
            object = balloon.getSegmentCenterToPointOnCircle(d).getFromAtoB(this.radius.getValue() - this.startAngle.getCurvation(0.0));
            point2D = balloon.getPointOnCirclePassingByThisPoint(balloon2.getCenter());
            uPath.lineTo((Point2D)object);
            uPath.arcTo(point2D, balloon2.getRadius(), 0.0, 1.0);
        } else {
            Object var11_10 = null;
            uPath.lineTo(point2D3);
        }
        if (this.endAngle.hasCurvation()) {
            object = balloon.getInsideTangentBalloon2(d2, this.endAngle.getCurvation(0.0));
            point2D = balloon.getPointOnCirclePassingByThisPoint(((Balloon)object).getCenter());
            Point2D point2D5 = balloon.getSegmentCenterToPointOnCircle(d2).getFromAtoB(this.radius.getValue() - this.endAngle.getCurvation(0.0));
            uPath.arcTo(point2D, balloon.getRadius(), 0.0, 1.0);
            uPath.arcTo(point2D5, ((Balloon)object).getRadius(), 0.0, 1.0);
        } else {
            object = null;
            uPath.arcTo(point2D4, balloon.getRadius(), 0.0, 1.0);
        }
        if (this.radius.hasCurvation()) {
            point2D = balloon.getSegmentCenterToPointOnCircle(d2).getFromAtoB(this.radius.getCurvation(0.0));
            uPath.lineTo(point2D);
            uPath.arcTo(point2D2, this.radius.getCurvation(0.0), 0.0, 1.0);
        } else {
            uPath.lineTo(balloon.getCenter());
        }
        uPath.closePath();
        uGraphic.draw(uPath);
    }

    public CuteShape rotateZoom(RotationZoom rotationZoom) {
        return new Cheese(this.radius, this.startAngle, this.endAngle, this.rotationZoom.compose(rotationZoom));
    }
}

