/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.cute.Arc;
import net.sourceforge.plantuml.cute.BetweenCorners;
import net.sourceforge.plantuml.cute.MyPoint2D;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.TriangleCorner;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

public class CutePath {
    private final List<Arc> arcs = new ArrayList<Arc>();

    public CutePath(String string) {
        MyPoint2D myPoint2D = null;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "~:", true);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(":")) continue;
            if (string3.equals("~")) {
                string2 = stringTokenizer.nextToken();
                object = stringTokenizer.nextToken();
                if (((String)object).equals("~")) continue;
                throw new IllegalArgumentException();
            }
            object = new StringTokenizer(string3.replaceAll("[()]", ""), ",^");
            MyPoint2D myPoint2D2 = new MyPoint2D((StringTokenizer)object);
            if (myPoint2D != null) {
                this.add(new Arc(myPoint2D, myPoint2D2).withTension(string2));
            }
            myPoint2D = myPoint2D2;
            string2 = null;
        }
        this.add(new Arc(myPoint2D, this.arcs.get(0).getA()).withTension(string2));
    }

    public CutePath() {
    }

    public void add(Arc arc) {
        Arc arc2;
        if (this.arcs.size() > 0 && !(arc2 = this.arcs.get(this.arcs.size() - 1)).getB().equals(arc.getA())) {
            throw new IllegalArgumentException("last=" + arc2.getB() + " arc=" + arc.getA());
        }
        this.arcs.add(arc);
    }

    private final MyPoint2D getMyPoint2D(int n) {
        return this.getArc(n).getA();
    }

    private Arc getArc(int n) {
        if (n == -1) {
            return this.arcs.get(this.arcs.size() - 1);
        }
        if (n == this.arcs.size()) {
            return this.arcs.get(0);
        }
        if (n == this.arcs.size() + 1) {
            return this.arcs.get(1);
        }
        return this.arcs.get(n);
    }

    private UPath toUPath() {
        TriangleCorner triangleCorner = new TriangleCorner(this.getMyPoint2D(0), this.getMyPoint2D(1), this.getMyPoint2D(2));
        int n = triangleCorner.determinant() < 0.0 ? 0 : 1;
        UPath uPath = new UPath();
        BetweenCorners betweenCorners = new BetweenCorners(this.getCorner(this.arcs.size() - 1), this.getCorner(this.arcs.size()), this.arcs.get(this.arcs.size() - 1).getTension());
        betweenCorners.initPath(uPath);
        for (int i = 0; i < this.arcs.size(); ++i) {
            BetweenCorners betweenCorners2 = new BetweenCorners(this.getCorner(i), this.getCorner(i + 1), this.arcs.get(i).getTension());
            betweenCorners2.addToPath(uPath, n);
        }
        uPath.closePath();
        return uPath;
    }

    private void debugMe(UGraphic uGraphic) {
        for (int i = 0; i < this.arcs.size(); ++i) {
            BetweenCorners betweenCorners = new BetweenCorners(this.getCorner(i), this.getCorner(i + 1), this.arcs.get(i).getTension());
            betweenCorners.debugMe(uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(null)));
        }
    }

    private Point2D getPointK(int n) {
        if (this.getMyPoint2D(n).hasCurvation()) {
            return this.getCorner(n).getOnSegmentB(this.getMyPoint2D(n).getCurvation(0.0));
        }
        return this.arcs.get(n - 1).getB();
    }

    private TriangleCorner getCorner(int n) {
        return new TriangleCorner(this.getMyPoint2D(n), this.getMyPoint2D(n - 1), this.getMyPoint2D(n + 1));
    }

    public void drawU(UGraphic uGraphic) {
        UPath uPath = this.toUPath();
        uGraphic.draw(uPath);
    }

    public CutePath rotateZoom(RotationZoom rotationZoom) {
        CutePath cutePath = new CutePath();
        for (Arc arc : this.arcs) {
            cutePath.arcs.add(arc.rotateZoom(rotationZoom));
        }
        return cutePath;
    }

    public CutePath withNoTension() {
        CutePath cutePath = new CutePath();
        for (Arc arc : this.arcs) {
            cutePath.arcs.add(arc.withNoTension());
        }
        return cutePath;
    }
}

