/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.CuteShape;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.VarArgs;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

public class Stick
implements CuteShape {
    private final double width;
    private final double height;
    private final RotationZoom rotationZoom;

    public Stick(VarArgs varArgs) {
        Point2D point2D = varArgs.getAsPoint("dimension");
        this.width = point2D.getX();
        this.height = point2D.getY();
        this.rotationZoom = RotationZoom.none();
    }

    private Stick(double d, double d2, RotationZoom rotationZoom) {
        this.width = d;
        this.height = d2;
        this.rotationZoom = rotationZoom;
    }

    public void drawU(UGraphic uGraphic) {
        if (this.width > this.height) {
            this.drawRotate1(uGraphic);
        } else {
            this.drawRotate2(uGraphic);
        }
    }

    private void drawRotate1(UGraphic uGraphic) {
        assert (this.width > this.height);
        UPath uPath = new UPath();
        double d = this.height / 2.0;
        uPath.moveTo(this.rotationZoom.getPoint(d, 0.0));
        uPath.lineTo(this.rotationZoom.getPoint(this.width - d, 0.0));
        uPath.arcTo(this.rotationZoom.getPoint(this.width - d, this.height), d, 0.0, 1.0);
        uPath.lineTo(this.rotationZoom.getPoint(d, this.height));
        uPath.arcTo(this.rotationZoom.getPoint(d, 0.0), d, 0.0, 1.0);
        uPath.closePath();
        uGraphic.draw(uPath);
    }

    private void drawRotate2(UGraphic uGraphic) {
        assert (this.height > this.width);
        UPath uPath = new UPath();
        double d = this.width / 2.0;
        uPath.moveTo(this.rotationZoom.getPoint(this.width, d));
        uPath.lineTo(this.rotationZoom.getPoint(this.width, this.height - d));
        uPath.arcTo(this.rotationZoom.getPoint(0.0, this.height - d), d, 0.0, 1.0);
        uPath.lineTo(this.rotationZoom.getPoint(0.0, d));
        uPath.arcTo(this.rotationZoom.getPoint(this.width, d), d, 0.0, 1.0);
        uPath.closePath();
        uGraphic.draw(uPath);
    }

    public Stick rotateZoom(RotationZoom rotationZoom) {
        return new Stick(this.width, this.height, this.rotationZoom.compose(rotationZoom));
    }
}

