/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.Balloon;

public class TriangleCornerSimple {
    private final Point2D a;
    private final Point2D b;

    public String toString() {
        return "TriangleCornerSimple a=" + this.a + " " + Math.toDegrees(this.getAngleA()) + " b=" + this.b + " " + Math.toDegrees(this.getAngleB());
    }

    public TriangleCornerSimple(Point2D point2D, Point2D point2D2) {
        if (!TriangleCornerSimple.isZero(point2D.getX())) {
            throw new IllegalArgumentException("a=" + point2D);
        }
        this.a = point2D;
        this.b = point2D2;
    }

    private static boolean isZero(double d) {
        return Math.abs(d) < 1.0E-4;
    }

    double getAngleA() {
        return this.getAngle(this.a);
    }

    double getAngleB() {
        return this.getAngle(this.b);
    }

    double getAngle(Point2D point2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        return Math.atan2(d2, d);
    }

    static double solveY(double d, double d2) {
        if (d < 0.0 || d > 1.5707963267948966) {
            throw new IllegalArgumentException();
        }
        return d2 * Math.tan(d);
    }

    static double solveX(double d, double d2) {
        if (d < -1.5707963267948966 || d > 1.5707963267948966) {
            // empty if block
        }
        double d3 = 1.5707963267948966 - d;
        return d2 * Math.tan(d3);
    }

    public Point2D getCenterWithFixedRadius(double d) {
        double d2 = (this.getAngleA() + this.getAngleB()) / 2.0;
        double d3 = TriangleCornerSimple.solveY(d2, d);
        return new Point2D.Double(d, d3);
    }

    public Balloon getBalloonWithFixedY(double d) {
        double d2 = (this.getAngleA() + this.getAngleB()) / 2.0;
        double d3 = Math.signum(this.a.getY());
        double d4 = TriangleCornerSimple.solveX(d2, d);
        Balloon balloon = new Balloon(new Point2D.Double(d4 * d3, d * d3), Math.abs(d4));
        return balloon;
    }
}

