/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eps;

import java.io.UnsupportedEncodingException;
import net.sourceforge.plantuml.eps.EpsGraphicsMacro;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UFontContext;

public class EpsGraphicsMacroAndText
extends EpsGraphicsMacro {
    public void drawText(String string, FontConfiguration fontConfiguration, double d, double d2) {
        this.append(EpsGraphicsMacroAndText.format(d) + " " + EpsGraphicsMacroAndText.format(d2) + " moveto", true);
        this.appendColor(this.getColor());
        UFont uFont = fontConfiguration.getFont();
        int n = uFont.getSize();
        this.append("/" + this.getPSName(fontConfiguration) + " findfont " + n + " scalefont setfont", true);
        this.append("1 -1 scale", true);
        this.append("(" + this.getTextAsEps(string) + ") show", false);
        this.append("1 -1 scale", true);
    }

    private String getPSName(FontConfiguration fontConfiguration) {
        UFont uFont = fontConfiguration.getFont();
        StringBuilder stringBuilder = new StringBuilder(uFont.getFamily(UFontContext.EPS));
        return stringBuilder.toString();
    }

    private String getTextAsEps(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c == '(') {
                stringBuilder.append("\\(");
                continue;
            }
            if (c == ')') {
                stringBuilder.append("\\)");
                continue;
            }
            if (c < ' ') {
                stringBuilder.append("?");
                continue;
            }
            if (c >= ' ' && c <= '\u007f') {
                stringBuilder.append(c);
                continue;
            }
            String string2 = "" + c;
            try {
                byte[] byArray = string2.getBytes("ISO-8859-1");
                if (byArray.length == 1) {
                    int n = byArray[0] & 0xFF;
                    stringBuilder.append("\\" + Integer.toOctalString(n));
                    continue;
                }
                stringBuilder.append('?');
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                stringBuilder.append('?');
            }
        }
        return stringBuilder.toString();
    }
}

