/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flashcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;

public class FlashCodeUtilsZxing
implements FlashCodeUtils {
    public BufferedImage exportFlashcode(String string) {
        try {
            QRCodeWriter qRCodeWriter = new QRCodeWriter();
            Hashtable<EncodeHintType, Object> hashtable = new Hashtable<EncodeHintType, Object>();
            hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            hashtable.put(EncodeHintType.CHARACTER_SET, "UTF8");
            BitMatrix bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, 1, hashtable);
            return MatrixToImageWriter.toBufferedImage(bitMatrix);
        }
        catch (WriterException writerException) {
            Log.debug("Cannot create flashcode " + writerException);
            return null;
        }
    }
}

