/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.font;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemListFonts
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();

    public PSystemListFonts(String string) {
        String[] stringArray;
        this.strings.add("   <b><size:16>Fonts available:");
        this.strings.add(" ");
        for (String string2 : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.strings.add(string2 + " : <font:" + string2 + ">" + string);
        }
    }

    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        GraphicStrings graphicStrings = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, graphicStrings.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.addUDrawable(graphicStrings);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, outputStream);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        UFont uFont = new UFont("SansSerif", 0, 12);
        GraphicStrings graphicStrings = new GraphicStrings(this.strings, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON);
        return graphicStrings;
    }

    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(List fonts)", this.getClass());
    }
}

