/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.geom.kinetic.Frame;
import net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import net.sourceforge.plantuml.geom.kinetic.SegmentCutter;
import net.sourceforge.plantuml.geom.kinetic.VectorForce;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path {
    private final Frame frame1;
    private final Frame frame2;
    private final List<Point2DCharge> points1 = new ArrayList<Point2DCharge>();
    private final Map<Point2DCharge, Integer> points2 = new HashMap<Point2DCharge, Integer>();
    private static final double MINDIST = 30.0;

    public Path(Frame frame, Frame frame2) {
        if (frame == null || frame2 == null) {
            throw new IllegalArgumentException();
        }
        this.frame1 = frame;
        this.frame2 = frame2;
        this.updateCharges();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.frame1.getMainCorner());
        for (Point2DCharge point2DCharge : this.points1) {
            stringBuilder.append(' ');
            stringBuilder.append(point2DCharge);
        }
        stringBuilder.append(this.frame2.getMainCorner());
        return stringBuilder.toString();
    }

    private void updateCharges() {
        for (Point2DCharge point2DCharge : this.points1) {
            point2DCharge.setCharge(1.0);
        }
    }

    public void renderContinue() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Point2D object2 = this.frame1.getMainCorner();
        for (Point2DCharge object3 : this.points1) {
            SegmentCutter segmentCutter = new SegmentCutter(object2, object3, 30.0);
            arrayList.addAll(segmentCutter.intermediates());
            object2 = object3;
        }
        SegmentCutter segmentCutter = new SegmentCutter(object2, this.frame2.getMainCorner(), 30.0);
        List<Point2D> list = segmentCutter.intermediates();
        arrayList.addAll(list.subList(0, list.size() - 1));
        this.points1.clear();
        this.points2.clear();
        for (Point2D point2D : arrayList) {
            this.addIntermediate(new Point2DCharge(point2D.getX(), point2D.getY()));
        }
    }

    public List<Line2D> segments() {
        ArrayList<Line2D.Double> arrayList = new ArrayList<Line2D.Double>();
        Point2D point2D = this.frame1.getMainCorner();
        for (Point2D point2D2 : this.points1) {
            arrayList.add(new Line2D.Double(point2D, point2D2));
            point2D = point2D2;
        }
        arrayList.add(new Line2D.Double(point2D, this.frame2.getMainCorner()));
        return Collections.unmodifiableList(arrayList);
    }

    public void addIntermediate(Point2DCharge point2DCharge) {
        assert (this.points1.size() == this.points2.size());
        assert (!this.points1.contains(point2DCharge));
        assert (!this.points2.containsKey(point2DCharge));
        assert (!this.containsPoint2DCharge(point2DCharge));
        this.points1.add(point2DCharge);
        this.points2.put(point2DCharge, this.points2.size());
        assert (this.points1.size() == this.points2.size());
        assert (this.points1.contains(point2DCharge));
        assert (this.points2.containsKey(point2DCharge));
        assert (this.containsPoint2DCharge(point2DCharge));
        this.updateCharges();
    }

    public VectorForce getElasticForce(Point2DCharge point2DCharge) {
        int n = this.points1.indexOf(point2DCharge);
        if (n == -1) {
            throw new UnsupportedOperationException();
        }
        Point2D point2D = this.getPosition(n - 1);
        Point2D point2D2 = this.getPosition(n + 1);
        VectorForce vectorForce = new VectorForce(point2DCharge, point2D);
        VectorForce vectorForce2 = new VectorForce(point2DCharge, point2D2);
        return vectorForce.plus(vectorForce2).multiply(0.2);
    }

    private Point2D getPosition(int n) {
        if (n == -1) {
            return this.frame1.getMainCorner();
        }
        if (n == this.points1.size()) {
            return this.frame2.getMainCorner();
        }
        return this.points1.get(n);
    }

    public boolean containsPoint2DCharge(Point2DCharge point2DCharge) {
        assert (this.points1.contains(point2DCharge) == this.points2.containsKey(point2DCharge)) : "p=" + point2DCharge + "v1=" + this.points1.contains(point2DCharge) + "v2=" + this.points2.containsKey(point2DCharge) + " points1=" + this.points1 + " points2=" + this.points2;
        return this.points2.containsKey(point2DCharge);
    }

    public final Collection<Point2DCharge> getPoints() {
        assert (this.points1.size() == this.points2.size());
        return Collections.unmodifiableCollection(this.points1);
    }
}

