/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.golem;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.golem.Path;
import net.sourceforge.plantuml.golem.Position;
import net.sourceforge.plantuml.golem.Tile;
import net.sourceforge.plantuml.golem.TileArea;
import net.sourceforge.plantuml.golem.TileGeometry;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesField
extends AbstractTextBlock
implements TextBlock {
    private int size = 1;
    private final Tile root = new Tile(0);
    private final Map<Tile, Position> positions = new HashMap<Tile, Position>();
    private final List<Path> paths = new ArrayList<Path>();

    public TilesField() {
        this.positions.put(this.root, new Position(0, 0, 1, 1));
    }

    public Tile getRoot() {
        return this.root;
    }

    public Tile createTile(Tile tile, TileGeometry tileGeometry) {
        Tile tile2 = new Tile(this.size++);
        Position position = this.getFreePosition(tile, tileGeometry);
        this.positions.put(tile2, position);
        this.paths.add(this.buildPath(tile.getArea(tileGeometry), tile2.getArea(tileGeometry.opposite())));
        return tile2;
    }

    public void addPath(Tile tile, Tile tile2, TileGeometry tileGeometry) {
        this.paths.add(this.buildPath(tile.getArea(tileGeometry), tile2.getArea(tileGeometry.opposite())));
    }

    private Path buildPath(TileArea tileArea, TileArea tileArea2) {
        if (this.isAdjoining(tileArea, tileArea2)) {
            return Path.build(tileArea, tileArea2);
        }
        Tile tile = tileArea.getTile();
        Tile tile2 = tileArea2.getTile();
        Position position = this.getPosition(tile);
        Position position2 = this.getPosition(tile2);
        TileGeometry tileGeometry = tileArea.getGeometry();
        TileGeometry tileGeometry2 = tileArea2.getGeometry();
        if (position.getYmin() == position2.getYmin() && position.getYmax() == position2.getYmax() && tileGeometry == TileGeometry.WEST && tileGeometry2 == TileGeometry.EAST) {
            return Path.build(tileArea, tileArea2);
        }
        throw new IllegalArgumentException();
    }

    private boolean isAdjoining(TileArea tileArea, TileArea tileArea2) {
        Tile tile = tileArea.getTile();
        Tile tile2 = tileArea2.getTile();
        Position position = this.getPosition(tile);
        Position position2 = this.getPosition(tile2);
        TileGeometry tileGeometry = tileArea.getGeometry();
        TileGeometry tileGeometry2 = tileArea2.getGeometry();
        if (position.equals(position2)) {
            assert (tile == tile2);
            if (tileGeometry == tileGeometry2) {
                throw new IllegalArgumentException();
            }
            return true;
        }
        if (!tileGeometry.equals((Object)tileGeometry2.opposite())) {
            return false;
        }
        switch (tileGeometry) {
            case EAST: {
                return position.getYmin() == position2.getYmin() && position.getYmax() == position2.getYmax() && position.getXmax() + 1 == position2.getXmin();
            }
            case WEST: {
                return position.getYmin() == position2.getYmin() && position.getYmax() == position2.getYmax() && position.getXmin() == position2.getXmax() + 1;
            }
            case SOUTH: {
                return position.getXmin() == position2.getXmin() && position.getXmax() == position2.getXmax() && position.getYmax() + 1 == position2.getYmin();
            }
            case NORTH: {
                return position.getXmin() == position2.getXmin() && position.getXmax() == position2.getXmax() && position.getYmin() == position2.getYmax() + 1;
            }
            case CENTER: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private Tile getTileAt(Position position) {
        for (Map.Entry<Tile, Position> entry : this.positions.entrySet()) {
            if (!position.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private Position getFreePosition(Tile tile, TileGeometry tileGeometry) {
        Position position = this.getPosition(tile).move(tileGeometry, 2);
        while (this.isOccuped(position)) {
            this.moveAllToEast(position);
        }
        return position;
    }

    private void moveAllToEast(Position position) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (Position position2 : this.positions.values()) {
            if (position2.getXmax() < position.getXmin() || position2.getYmax() < position.getYmin()) continue;
            arrayList.add(position2);
        }
        for (Position position2 : arrayList) {
            this.positions.put(this.getTileAt(position2), position2.move(TileGeometry.EAST, 2));
        }
    }

    private boolean isOccuped(Position position) {
        for (Position position2 : this.positions.values()) {
            if (!position2.equals(position)) continue;
            return true;
        }
        return false;
    }

    public Position getPosition(Tile tile) {
        Position position = this.positions.get(tile);
        if (position == null) {
            throw new IllegalArgumentException();
        }
        return position;
    }

    private int getXmin() {
        int n = Integer.MAX_VALUE;
        for (Position position : this.positions.values()) {
            int n2 = position.getXmin();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private int getYmin() {
        int n = Integer.MAX_VALUE;
        for (Position position : this.positions.values()) {
            int n2 = position.getYmin();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private int getXmax() {
        int n = Integer.MIN_VALUE;
        for (Position position : this.positions.values()) {
            int n2 = position.getXmax();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getYmax() {
        int n = Integer.MIN_VALUE;
        for (Position position : this.positions.values()) {
            int n2 = position.getYmax();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public List<Path> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Object object;
        Object object2;
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getXmin();
        int n2 = this.getYmin();
        Dimension2D dimension2D = this.root.calculateDimension(uGraphic.getStringBounder());
        d -= (double)n * dimension2D.getWidth() / 2.0;
        d2 -= (double)n2 * dimension2D.getHeight() / 2.0;
        for (Map.Entry<Tile, Position> object3 : this.positions.entrySet()) {
            object2 = object3.getValue();
            object = object3.getKey();
            double d3 = (double)((Position)object2).getXmin() * dimension2D.getWidth() / 2.0;
            double d4 = (double)((Position)object2).getYmin() * dimension2D.getHeight() / 2.0;
            ((Tile)object).drawU(uGraphic.apply(new UTranslate(d + d3, d2 + d4)));
        }
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.RED));
        for (Path path : this.paths) {
            object2 = path.getStart();
            object = path.getDest();
            Point2D point2D = this.getPoint2D(dimension2D, (TileArea)object2);
            Point2D point2D2 = this.getPoint2D(dimension2D, (TileArea)object);
            uGraphic.apply(new UTranslate(d + point2D.getX(), d2 + point2D.getY())).draw(new ULine(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY()));
        }
    }

    private Point2D getPoint2D(Dimension2D dimension2D, TileArea tileArea) {
        Position position = this.getPosition(tileArea.getTile());
        double d = (double)position.getXmin() * dimension2D.getWidth() / 2.0;
        double d2 = (double)position.getYmin() * dimension2D.getHeight() / 2.0;
        d += dimension2D.getWidth() / 2.0;
        d2 += dimension2D.getHeight() / 2.0;
        switch (tileArea.getGeometry()) {
            case NORTH: {
                d2 -= dimension2D.getHeight() * 0.33;
                break;
            }
            case SOUTH: {
                d2 += dimension2D.getHeight() * 0.33;
                break;
            }
            case EAST: {
                d += dimension2D.getWidth() * 0.33;
                break;
            }
            case WEST: {
                d -= dimension2D.getWidth() * 0.33;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new Point2D.Double(d, d2);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        int n = this.getXmin();
        int n2 = this.getXmax();
        int n3 = this.getYmin();
        int n4 = this.getYmax();
        int n5 = (n2 - n) / 2 + 1;
        int n6 = (n4 - n3) / 2 + 1;
        Dimension2D dimension2D = this.root.calculateDimension(stringBounder);
        return new Dimension2DDouble((double)n5 * dimension2D.getWidth(), (double)n6 * dimension2D.getHeight());
    }
}

