/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.geom.InflationTransform;
import net.sourceforge.plantuml.geom.Kingdom;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.Polyline;
import net.sourceforge.plantuml.geom.PolylineImpl;
import net.sourceforge.plantuml.geom.XMoveable;
import net.sourceforge.plantuml.geom.kinetic.Frame;
import net.sourceforge.plantuml.geom.kinetic.Path;
import net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import net.sourceforge.plantuml.geom.kinetic.World;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph3 {
    private static final Graphics2D dummyGraphics2D;
    private final int spaceWidth = 40;
    private final int spaceHeight = 40;
    private final int minDistBetweenPoint = 20;
    private final double margin = 30.0;
    private final Board board;
    private final List<PolylineImpl> polylines = new ArrayList<PolylineImpl>();
    private final Map<ANode, ANodePoint> nodePoints = new LinkedHashMap<ANode, ANodePoint>();
    private int maxRow;
    private int maxCol;
    private int addedWidth = 0;
    private int addedHeight = 0;
    private final World world = new World();
    private final Map<ANodePoint, Frame> frames = new LinkedHashMap<ANodePoint, Frame>();
    private static final int STEP = 1;

    private Collection<XMoveable> convertANodeSet(Set<ANode> set) {
        HashSet<XMoveable> hashSet = new HashSet<XMoveable>();
        for (ANode aNode : set) {
            assert (this.nodePoints.get(aNode) != null);
            hashSet.add(this.nodePoints.get(aNode));
        }
        return hashSet;
    }

    public Graph3(Board board) {
        Object object;
        Point2DInt point2DInt;
        board.normalize();
        this.board = board;
        for (ANode iterator : board.getNodes()) {
            this.maxRow = Math.max(this.maxRow, iterator.getRow());
            this.maxCol = Math.max(this.maxCol, board.getCol(iterator));
        }
        for (ANode aNode : board.getNodes()) {
            this.nodePoints.put(aNode, new ANodePoint(aNode));
        }
        this.computePolylines(board);
        InflationTransform inflationTransform = new InflationTransform();
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            point2DInt = aNodePoint.getPosition();
            object = this.getImage(aNodePoint.getNode());
            int n = (int)((AbstractEntityImage)object).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getWidth();
            int n2 = (int)((AbstractEntityImage)object).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getHeight();
            if (n % 2 == 1) {
                ++n;
            }
            if (n2 % 2 == 1) {
                ++n2;
            }
            inflationTransform.addInflationX(point2DInt.getXint(), n);
            this.addedWidth += n;
            inflationTransform.addInflationY(point2DInt.getYint(), n2);
            this.addedHeight += n2;
        }
        for (PolylineImpl polylineImpl : this.polylines) {
            polylineImpl.inflate(inflationTransform);
        }
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            point2DInt = aNodePoint.getPosition();
            object = inflationTransform.inflatePoint2DInt(point2DInt);
            aNodePoint.moveX(((Point2DInt)object).getXint() - point2DInt.getXint());
            aNodePoint.moveY(((Point2DInt)object).getYint() - point2DInt.getYint());
        }
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            double d = aNodePoint.getPosition().getX();
            double d2 = aNodePoint.getPosition().getY();
            Dimension2D dimension2D = this.getImage(aNodePoint.getNode()).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D));
            Frame frame = new Frame(d, d2, (int)dimension2D.getWidth(), (int)dimension2D.getHeight());
            this.frames.put(aNodePoint, frame);
            this.world.addFrame(frame);
        }
        for (PolylineImpl polylineImpl : this.polylines) {
            Frame frame = this.frames.get(polylineImpl.getStart());
            object = this.frames.get(polylineImpl.getEnd());
            Path path = new Path(frame, (Frame)object);
            for (Point2DInt point2DInt2 : polylineImpl.getIntermediates()) {
                path.addIntermediate(new Point2DCharge(point2DInt2.getX(), point2DInt2.getY()));
            }
            this.world.addPath(path);
        }
        this.world.renderContinue();
        Log.info("Starting moving");
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            Log.info("i=" + i);
            double d = this.world.onePass();
            if (d < 1.0) {
                Log.info("i=" + i + " " + d);
            }
            if (i != 99) continue;
            Log.info("Aborting");
        }
        long l2 = System.currentTimeMillis() - l;
        Log.info("Ending moving (" + l2 + " ms)");
    }

    private void computePolylines(Board board) {
        Pointable pointable;
        Pointable pointable2;
        ArrayList<ALink> arrayList = new ArrayList<ALink>();
        Kingdom kingdom = new Kingdom();
        ArrayList<? extends ALink> arrayList2 = new ArrayList<ALink>(board.getLinks());
        Collections.sort(arrayList2, board.getLinkComparator());
        for (ALink aLink : arrayList2) {
            pointable2 = this.nodePoints.get(aLink.getNode1());
            pointable = this.nodePoints.get(aLink.getNode2());
            if (kingdom.isSimpleSegmentPossible(pointable2.getPosition(), pointable.getPosition())) {
                Log.println("OK for " + aLink);
                kingdom.addDirectLink(pointable2.getPosition(), pointable.getPosition());
                this.polylines.add(new PolylineImpl(pointable2, pointable));
                continue;
            }
            Log.println("Latter for " + aLink);
            arrayList.add(aLink);
        }
        Log.println("latters=" + arrayList.size());
        for (ALink aLink : arrayList) {
            Log.println("Alatter=" + aLink);
        }
        for (ALink aLink : arrayList) {
            Log.println("Blatter=" + aLink);
            pointable2 = this.nodePoints.get(aLink.getNode1());
            pointable = this.nodePoints.get(aLink.getNode2());
            this.polylines.add((PolylineImpl)kingdom.getPath(pointable2, pointable));
        }
    }

    private void manyPasses(Board board) {
        boolean bl;
        Collection<Collection<XMoveable>> collection = this.getXMoveables(board);
        Log.println("COST_INIT=" + this.getCost());
        for (int i = 0; i < 300 && (bl = this.onePass(collection)); ++i) {
        }
        Log.println("COST_FIN=" + this.getCost());
    }

    private Collection<Collection<XMoveable>> getXMoveables(Board board) {
        HashSet<Set<ANode>> hashSet = new HashSet<Set<ANode>>();
        Collection<ANode> collection = board.getNodes();
        for (ANode object : collection) {
            for (int i = 0; i < board.getLinks().size(); ++i) {
                Set<ANode> set = board.getConnectedNodes(object, i);
                if (set.size() >= collection.size()) continue;
                hashSet.add(set);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Set set : hashSet) {
            arrayList.add(this.convertANodeSet(set));
        }
        return arrayList;
    }

    private void moveX(Collection<XMoveable> collection, int n) {
        for (XMoveable xMoveable : collection) {
            xMoveable.moveX(n);
        }
    }

    private boolean onePass(Collection<? extends Collection<XMoveable>> collection) {
        boolean bl = false;
        for (Collection<XMoveable> collection2 : collection) {
            double d = this.getCost();
            assert (this.reversable(d, collection2));
            this.moveX(collection2, 1);
            if (this.getCost() < d) {
                bl = true;
            } else {
                this.moveX(collection2, -1);
                this.moveX(collection2, -1);
                if (this.getCost() < d) {
                    bl = true;
                } else {
                    this.moveX(collection2, 1);
                    assert (this.getCost() == d) : "c1=" + this.getCost() + " init=" + d;
                }
            }
            assert (this.getCost() <= d);
        }
        return bl;
    }

    private boolean reversable(double d, Collection<XMoveable> collection) {
        this.moveX(collection, 1);
        this.moveX(collection, -1);
        assert (this.getCost() == d);
        this.moveX(collection, 1);
        this.moveX(collection, -2);
        this.moveX(collection, 1);
        assert (this.getCost() == d);
        return true;
    }

    private double getCostOld() {
        if (!this.mindistRespected()) {
            return Double.MAX_VALUE;
        }
        double d = 0.0;
        for (PolylineImpl polylineImpl : this.polylines) {
            d += this.getLength(polylineImpl);
            for (PolylineImpl polylineImpl2 : this.polylines) {
                if (polylineImpl2 == polylineImpl || !polylineImpl.doesTouch(polylineImpl2)) continue;
                d += this.getLength(polylineImpl2);
            }
        }
        return d;
    }

    private double getCost() {
        double d = 0.0;
        for (PolylineImpl polylineImpl : this.polylines) {
            for (PolylineImpl polylineImpl2 : this.polylines) {
                d += this.getCost(polylineImpl, polylineImpl2);
            }
        }
        ArrayList<ANodePoint> arrayList = new ArrayList<ANodePoint>(this.nodePoints.values());
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                double d2 = new LineSegmentInt(((ANodePoint)arrayList.get(i)).getPosition(), ((ANodePoint)arrayList.get(j)).getPosition()).getLength();
                d += 400.0 / d2 / d2;
            }
        }
        return d;
    }

    private double getCost(PolylineImpl polylineImpl, PolylineImpl polylineImpl2) {
        assert (polylineImpl.nbSegments() == 1);
        assert (polylineImpl2.nbSegments() == 1);
        LineSegmentInt lineSegmentInt = polylineImpl.getFirst();
        LineSegmentInt lineSegmentInt2 = polylineImpl2.getFirst();
        double d = lineSegmentInt.getLength();
        if (polylineImpl == polylineImpl2) {
            return d / 20.0;
        }
        double d2 = lineSegmentInt2.getLength();
        return d * d2 / lineSegmentInt.getDistance(lineSegmentInt2) / 20.0 / 20.0;
    }

    private boolean mindistRespected() {
        ArrayList<ANodePoint> arrayList = new ArrayList<ANodePoint>(this.nodePoints.values());
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                double d = new LineSegmentInt(((ANodePoint)arrayList.get(i)).getPosition(), ((ANodePoint)arrayList.get(j)).getPosition()).getLength();
                if (!(d <= 20.0)) continue;
                return false;
            }
        }
        return true;
    }

    private double getLength(Polyline polyline) {
        double d = polyline.getLength();
        assert (d > 0.0);
        return Math.log(1.0 + d);
    }

    public Dimension2D getDimension() {
        double d = 40 * this.maxCol;
        int n = 40 * this.maxRow;
        return new Dimension2DDouble(d + 60.0 + (double)this.addedWidth, (double)n + 60.0 + (double)this.addedHeight);
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.translate(30.0, 30.0);
        for (Path object : this.world.getPaths()) {
            for (Line2D line2D : object.segments()) {
                graphics2D.setColor(Color.BLUE);
                graphics2D.draw(line2D);
                graphics2D.setColor(Color.RED);
                graphics2D.drawOval((int)line2D.getX1(), (int)line2D.getY1(), 1, 1);
            }
        }
        graphics2D.setColor(Color.GREEN);
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            Frame frame = this.frames.get(aNodePoint);
            AbstractEntityImage abstractEntityImage = this.getImage(aNodePoint.getNode());
            double d = abstractEntityImage.getDimension(StringBounderUtils.asStringBounder(graphics2D)).getWidth();
            double d2 = abstractEntityImage.getDimension(StringBounderUtils.asStringBounder(graphics2D)).getHeight();
            graphics2D.translate(frame.getX() - d / 2.0, frame.getY() - d2 / 2.0);
            abstractEntityImage.draw(new ColorMapperIdentity(), graphics2D);
            graphics2D.translate(-frame.getX() + d / 2.0, -frame.getY() + d2 / 2.0);
        }
    }

    public void draw2(Graphics2D graphics2D) {
        graphics2D.translate(30.0, 30.0);
        graphics2D.setColor(Color.BLUE);
        for (Polyline object : this.polylines) {
            if (object == null) {
                Log.println("Polyline NULL!!");
                continue;
            }
            for (LineSegmentInt lineSegmentInt : object.segments()) {
                graphics2D.drawLine(lineSegmentInt.getP1().getXint(), lineSegmentInt.getP1().getYint(), lineSegmentInt.getP2().getXint(), lineSegmentInt.getP2().getYint());
            }
        }
        graphics2D.setColor(Color.GREEN);
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            Point2DInt point2DInt = aNodePoint.getPosition();
            AbstractEntityImage abstractEntityImage = this.getImage(aNodePoint.getNode());
            int n = (int)abstractEntityImage.getDimension(StringBounderUtils.asStringBounder(graphics2D)).getWidth();
            int n2 = (int)abstractEntityImage.getDimension(StringBounderUtils.asStringBounder(graphics2D)).getHeight();
            graphics2D.translate(point2DInt.getXint() - n / 2, point2DInt.getYint() - n2 / 2);
            abstractEntityImage.draw(new ColorMapperIdentity(), graphics2D);
            graphics2D.translate(-point2DInt.getXint() + n / 2, -point2DInt.getYint() + n2 / 2);
        }
    }

    private AbstractEntityImage getImage(ANode aNode) {
        return new EntityImageFactory().createEntityImage((IEntity)aNode.getUserData());
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        dummyGraphics2D = emptyImageBuilder.getGraphics2D();
    }

    class ANodePoint
    implements Pointable,
    XMoveable {
        private final ANode node;
        private int deltaX = 0;
        private int deltaY = 0;

        public ANodePoint(ANode aNode) {
            this.node = aNode;
        }

        public Point2DInt getPosition() {
            return new Point2DInt(Graph3.this.board.getCol(this.node) * 40 + this.deltaX, this.node.getRow() * 40 + this.deltaY);
        }

        public void moveX(int n) {
            this.deltaX += n;
        }

        public void moveY(int n) {
            this.deltaY += n;
        }

        public ANode getNode() {
            return this.node;
        }
    }
}

