/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolNode
extends USymbol {
    USymbolNode() {
    }

    public SkinParameter getSkinParameter() {
        return SkinParameter.NODE;
    }

    private void drawNode(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 10.0);
        uPolygon.addPoint(10.0, 0.0);
        uPolygon.addPoint(d, 0.0);
        uPolygon.addPoint(d, d2 - 10.0);
        uPolygon.addPoint(d - 10.0, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 10.0);
        if (bl) {
            uPolygon.setDeltaShadow(2.0);
        }
        uGraphic.draw(uPolygon);
        uGraphic.apply(new UTranslate(d - 10.0, 10.0)).draw(new ULine(9.0, -9.0));
        uGraphic.apply(new UTranslate(0.0, 10.0)).draw(new ULine(d - 10.0, 0.0));
        uGraphic.apply(new UTranslate(d - 10.0, 10.0)).draw(new ULine(0.0, d2 - 10.0));
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    public TextBlock asSmall(TextBlock textBlock, final TextBlock textBlock2, final TextBlock textBlock3, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolNode.this.drawNode(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolNode.this.getMargin();
                TextBlock textBlock = TextBlockUtils.mergeTB(textBlock3, textBlock2, HorizontalAlignment.CENTER);
                textBlock.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock3.calculateDimension(stringBounder);
                return USymbolNode.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolNode.this.drawNode(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                uGraphic = uGraphic.apply(new UTranslate(-4.0, 11.0));
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D2.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic.apply(new UTranslate(d3, 2.0)));
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                double d22 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d22, 2.0 + dimension2D2.getHeight())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public int suppHeightBecauseOfShape() {
        return 5;
    }

    public int suppWidthBecauseOfShape() {
        return 60;
    }
}

