/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.hector2.MinMax;
import net.sourceforge.plantuml.hector2.graphic.Foo1;
import net.sourceforge.plantuml.hector2.layering.Layer;
import net.sourceforge.plantuml.hector2.mpos.Distribution;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Foo2
extends AbstractTextBlock
implements TextBlock {
    private final Distribution distribution;
    private final CucaDiagram diagram;

    public Foo2(Distribution distribution, CucaDiagram cucaDiagram) {
        this.distribution = distribution;
        this.diagram = cucaDiagram;
    }

    public Dimension2D getMaxCellDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = new Dimension2DDouble(0.0, 0.0);
        for (Layer layer : this.distribution.getLayers()) {
            Dimension2D dimension2D2 = Foo1.getMaxCellDimension(stringBounder, layer, this.diagram);
            dimension2D = Dimension2DDouble.max(dimension2D, dimension2D2);
        }
        return dimension2D;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getMaxCellDimension(stringBounder);
        MinMax minMax = this.distribution.getMinMaxLongitudes();
        double d = (double)(minMax.getDiff() + 2) * dimension2D.getWidth() / 2.0;
        double d2 = dimension2D.getHeight() * this.distribution.getNbLayers();
        return new Dimension2DDouble(d, d2);
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getMaxCellDimension(stringBounder);
        for (Layer layer : this.distribution.getLayers()) {
            this.drawLayer(uGraphic, layer, dimension2D.getWidth(), dimension2D.getHeight());
            uGraphic = uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight()));
        }
    }

    private void drawLayer(UGraphic uGraphic, Layer layer, double d, double d2) {
        for (IEntity iEntity : layer.entities()) {
            IEntityImage iEntityImage = this.computeImage((ILeaf)iEntity);
            int n = layer.getLongitude(iEntity);
            Dimension2D dimension2D = iEntityImage.calculateDimension(uGraphic.getStringBounder());
            double d3 = d - dimension2D.getWidth();
            double d4 = d2 - dimension2D.getHeight();
            iEntityImage.drawU(uGraphic.apply(new UTranslate(d * (double)n / 2.0 + d3 / 2.0, d4 / 2.0)));
        }
    }

    private IEntityImage computeImage(ILeaf iLeaf) {
        IEntityImage iEntityImage = CucaDiagramFileMakerSvek2.createEntityImageBlock(iLeaf, this.diagram.getSkinParam(), false, this.diagram, null, null, null);
        return iEntityImage;
    }
}

