/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.jungle.GNode;
import net.sourceforge.plantuml.jungle.GTile;
import net.sourceforge.plantuml.jungle.GTileGeometry;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class GTileNode
extends AbstractTextBlock
implements GTile {
    private final TextBlock tb;

    public GTileNode(GNode gNode) {
        Display display = gNode.getDisplay();
        SheetBlock1 sheetBlock1 = GTileNode.getTextBlock(display);
        SymbolContext symbolContext = new SymbolContext(HtmlColorUtils.MY_YELLOW, HtmlColorUtils.BLACK);
        this.tb = USymbol.RECTANGLE.asSmall(null, sheetBlock1, TextBlockUtils.empty(0.0, 0.0), symbolContext);
    }

    public static SheetBlock1 getTextBlock(Display display) {
        Rose rose = new Rose();
        SkinParam skinParam = new SkinParam();
        HtmlColor htmlColor = rose.getFontColor(skinParam, FontParam.NOTE);
        UFont uFont = skinParam.getFont(null, false, FontParam.NOTE);
        FontConfiguration fontConfiguration = new FontConfiguration(skinParam, FontParam.NOTE, null);
        Sheet sheet = new CreoleParser(fontConfiguration, HorizontalAlignment.LEFT, skinParam, CreoleMode.FULL).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, 0.0, 0.0);
        return sheetBlock1;
    }

    public void drawU(UGraphic uGraphic) {
        this.tb.drawU(uGraphic);
    }

    public GTileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.tb.calculateDimension(stringBounder);
        return new GTileGeometry(dimension2D, Arrays.asList(dimension2D.getHeight() / 2.0));
    }
}

