/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.IfManagerNegatif;
import net.sourceforge.plantuml.preproc.IfManagerPositif;
import net.sourceforge.plantuml.preproc.ReadLine;

class IfManager
implements ReadLine {
    protected static final Pattern ifdefPattern = MyPattern.cmpile("^[%s]*!if(n)?def[%s]+([A-Za-z_][A-Za-z_0-9]*)$");
    protected static final Pattern elsePattern = MyPattern.cmpile("^[%s]*!else$");
    protected static final Pattern endifPattern = MyPattern.cmpile("^[%s]*!endif$");
    private final Defines defines;
    private final ReadLine source;
    private IfManager child;

    public IfManager(ReadLine readLine, Defines defines) {
        this.defines = defines;
        this.source = readLine;
    }

    public final CharSequence2 readLine() throws IOException {
        if (this.child != null) {
            CharSequence2 charSequence2 = this.child.readLine();
            if (charSequence2 != null) {
                return charSequence2;
            }
            this.child = null;
        }
        return this.readLineInternal();
    }

    protected CharSequence2 readLineInternal() throws IOException {
        CharSequence2 charSequence2 = this.source.readLine();
        if (charSequence2 == null) {
            return null;
        }
        Matcher matcher = ifdefPattern.matcher(charSequence2);
        if (matcher.find()) {
            boolean bl = this.defines.isDefine(matcher.group(2));
            if (matcher.group(1) != null) {
                bl = !bl;
            }
            this.child = bl ? new IfManagerPositif(this.source, this.defines) : new IfManagerNegatif(this.source, this.defines);
            return this.readLine();
        }
        return charSequence2;
    }

    public void close() throws IOException {
        this.source.close();
    }
}

