/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.utils.StartUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreprocessorInclude
implements ReadLine {
    private static final Pattern includePattern = MyPattern.cmpile("^[%s]*!include[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern includeURLPattern = MyPattern.cmpile("^[%s]*!includeurl[%s]+[%g]?([^%g]+)[%g]?$");
    private final ReadLine reader2;
    private final String charset;
    private final Defines defines;
    private int numLine = 0;
    private PreprocessorInclude included = null;
    private final File oldCurrentDir;
    private final Set<FileWithSuffix> filesUsedCurrent;
    private final Set<FileWithSuffix> filesUsedGlobal;

    public PreprocessorInclude(ReadLine readLine, Defines defines, String string, File file) {
        this(readLine, defines, string, file, new HashSet<FileWithSuffix>(), new HashSet<FileWithSuffix>());
    }

    public Set<FileWithSuffix> getFilesUsedGlobal() {
        return Collections.unmodifiableSet(this.filesUsedGlobal);
    }

    private PreprocessorInclude(ReadLine readLine, Defines defines, String string, File file, Set<FileWithSuffix> set, Set<FileWithSuffix> set2) {
        this.defines = defines;
        this.charset = string;
        this.reader2 = readLine;
        this.filesUsedCurrent = set;
        this.filesUsedGlobal = set2;
        if (file == null) {
            this.oldCurrentDir = null;
        } else {
            this.oldCurrentDir = FileSystem.getInstance().getCurrentDir();
            FileSystem.getInstance().setCurrentDir(file);
        }
    }

    private void restoreCurrentDir() {
        if (this.oldCurrentDir != null) {
            FileSystem.getInstance().setCurrentDir(this.oldCurrentDir);
        }
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        CharSequence2 charSequence2 = this.readLineInternal();
        if (charSequence2 != null && (StartUtils.isArobaseEndDiagram(charSequence2) || StartUtils.isArobaseStartDiagram(charSequence2))) {
            this.filesUsedCurrent.clear();
        }
        return charSequence2;
    }

    private CharSequence2 readLineInternal() throws IOException {
        Matcher matcher;
        CharSequence2 charSequence2;
        if (this.included != null) {
            charSequence2 = this.included.readLine();
            if (charSequence2 != null) {
                return charSequence2;
            }
            this.included.close();
            this.included = null;
        }
        charSequence2 = this.reader2.readLine();
        ++this.numLine;
        if (charSequence2 == null) {
            return null;
        }
        if (OptionFlags.ALLOW_INCLUDE) {
            matcher = includePattern.matcher(charSequence2);
            assert (this.included == null);
            if (matcher.find()) {
                return this.manageFileInclude(matcher, charSequence2.getLocation());
            }
        }
        if ((matcher = includeURLPattern.matcher(charSequence2)).find()) {
            return this.manageUrlInclude(matcher, charSequence2.getLocation());
        }
        return charSequence2;
    }

    private CharSequence2 manageUrlInclude(Matcher matcher, LineLocation lineLocation) throws IOException {
        String string = matcher.group(1);
        string = this.defines.applyDefines(string).get(0);
        int n = string.lastIndexOf(33);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        try {
            URL uRL = new URL(string);
            this.included = new PreprocessorInclude(this.getReaderInclude(uRL, string2, lineLocation), this.defines, this.charset, null, this.filesUsedCurrent, this.filesUsedGlobal);
        }
        catch (MalformedURLException malformedURLException) {
            return CharSequence2Impl.errorPreprocessor("Cannot include url " + string, lineLocation);
        }
        return this.readLine();
    }

    private CharSequence2 manageFileInclude(Matcher matcher, LineLocation lineLocation) throws IOException {
        String string = matcher.group(1);
        string = this.defines.applyDefines(string).get(0);
        int n = string.lastIndexOf(33);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        File file = FileSystem.getInstance().getFile(PreprocessorInclude.withEnvironmentVariable(string));
        FileWithSuffix fileWithSuffix = new FileWithSuffix(file, string2);
        if (!file.exists()) {
            return CharSequence2Impl.errorPreprocessor("Cannot include " + file.getAbsolutePath(), lineLocation);
        }
        if (this.filesUsedCurrent.contains(fileWithSuffix)) {
            return CharSequence2Impl.errorPreprocessor("File already included " + file.getAbsolutePath(), lineLocation);
        }
        this.filesUsedCurrent.add(fileWithSuffix);
        this.filesUsedGlobal.add(fileWithSuffix);
        this.included = new PreprocessorInclude(this.getReaderInclude(file, string2, lineLocation), this.defines, this.charset, file.getParentFile(), this.filesUsedCurrent, this.filesUsedGlobal);
        return this.readLine();
    }

    static String withEnvironmentVariable(String string) {
        Pattern pattern = Pattern.compile("%(\\w+)%");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = PreprocessorInclude.getenv(string2);
            if (string3 == null) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        return string;
    }

    private static String getenv(String string) {
        String string2 = System.getProperty(string);
        if (StringUtils.isNotEmpty(string2)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        String string3 = System.getenv(string);
        if (StringUtils.isNotEmpty(string3)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3);
        }
        return null;
    }

    private ReadLine getReaderInclude(File file, String string, LineLocation lineLocation) throws IOException {
        if (StartDiagramExtractReader.containsStartDiagram(file, this.charset)) {
            int n = 0;
            if (string != null && string.matches("\\d+")) {
                n = Integer.parseInt(string);
            }
            return new StartDiagramExtractReader(file, n, this.charset);
        }
        if (this.charset == null) {
            Log.info("Using default charset");
            return new ReadLineReader(new FileReader(file), file.getAbsolutePath(), lineLocation);
        }
        Log.info("Using charset " + this.charset);
        return new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset), file.getAbsolutePath(), lineLocation);
    }

    private ReadLine getReaderInclude(URL uRL, String string, LineLocation lineLocation) throws IOException {
        if (StartDiagramExtractReader.containsStartDiagram(uRL, this.charset)) {
            int n = 0;
            if (string != null && string.matches("\\d+")) {
                n = Integer.parseInt(string);
            }
            return new StartDiagramExtractReader(uRL, n, this.charset);
        }
        InputStream inputStream = uRL.openStream();
        if (this.charset == null) {
            Log.info("Using default charset");
            return new ReadLineReader(new InputStreamReader(inputStream), uRL.toString(), lineLocation);
        }
        Log.info("Using charset " + this.charset);
        return new ReadLineReader(new InputStreamReader(inputStream, this.charset), uRL.toString(), lineLocation);
    }

    public int getLineNumber() {
        return this.numLine;
    }

    @Override
    public void close() throws IOException {
        this.restoreCurrentDir();
        this.reader2.close();
    }
}

