/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public StartDiagramExtractReader(File file, int n, String string) throws IOException {
        this(StartDiagramExtractReader.getReadLine(file, string), n, string);
    }

    public StartDiagramExtractReader(URL uRL, int n, String string) throws IOException {
        this(StartDiagramExtractReader.getReadLine(uRL, string), n, string);
    }

    private StartDiagramExtractReader(ReadLine readLine, int n, String string) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.raw = readLine;
        CharSequence2 charSequence2 = null;
        while ((charSequence2 = readLine.readLine()) != null) {
            if (!StartUtils.isArobaseStartDiagram(charSequence2)) continue;
            if (n == 0) {
                return;
            }
            --n;
        }
        this.finished = true;
    }

    private static ReadLine getReadLine(File file, String string) throws IOException {
        if (string == null) {
            Log.info("Using default charset");
            return new UncommentReadLine(new ReadLineReader(new FileReader(file), file.getAbsolutePath()));
        }
        Log.info("Using charset " + string);
        return new UncommentReadLine(new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(file), string), file.getAbsolutePath()));
    }

    private static ReadLine getReadLine(URL uRL, String string) throws IOException {
        if (string == null) {
            Log.info("Using default charset");
            return new UncommentReadLine(new ReadLineReader(new InputStreamReader(uRL.openStream()), uRL.toString()));
        }
        Log.info("Using charset " + string);
        return new UncommentReadLine(new ReadLineReader(new InputStreamReader(uRL.openStream(), string), uRL.toString()));
    }

    public static boolean containsStartDiagram(File file, String string) throws IOException {
        ReadLine readLine = StartDiagramExtractReader.getReadLine(file, string);
        return StartDiagramExtractReader.containsStartDiagram(readLine);
    }

    public static boolean containsStartDiagram(URL uRL, String string) throws IOException {
        ReadLine readLine = StartDiagramExtractReader.getReadLine(uRL, string);
        return StartDiagramExtractReader.containsStartDiagram(readLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean containsStartDiagram(ReadLine readLine) throws IOException {
        boolean bl;
        try {
            CharSequence2 charSequence2 = null;
            while ((charSequence2 = readLine.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(charSequence2)) continue;
                bl = true;
                Object var4_3 = null;
                if (readLine == null) return bl;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (readLine == null) throw throwable;
            readLine.close();
            throw throwable;
        }
        {
            readLine.close();
            return bl;
        }
        Object var4_4 = null;
        if (readLine == null) return false;
        readLine.close();
        return false;
    }

    public CharSequence2 readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        CharSequence2 charSequence2 = this.raw.readLine();
        if (charSequence2 != null && StartUtils.isArobaseEndDiagram(charSequence2)) {
            this.finished = true;
            return null;
        }
        return charSequence2;
    }

    public void close() throws IOException {
        this.raw.close();
    }
}

