/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.project.Project;
import net.sourceforge.plantuml.project.graphic.GanttDiagram;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public class PSystemProject
extends AbstractPSystem {
    private final Project project = new Project();
    private final Color background = Color.WHITE;
    private final ColorMapper colorMapper = new ColorMapperIdentity();

    public int getNbImages() {
        return 1;
    }

    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Project)", this.getClass());
    }

    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        GanttDiagram ganttDiagram = new GanttDiagram(this.project);
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage bufferedImage = this.createImage(ganttDiagram);
            PngIO.write((RenderedImage)bufferedImage, outputStream, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, 96);
        } else if (fileFormat == FileFormat.SVG) {
            UGraphicSvg uGraphicSvg = new UGraphicSvg(this.colorMapper, StringUtils.getAsHtml(this.background), false, 1.0, fileFormatOption.getSvgLinkTarget());
            ganttDiagram.draw(uGraphicSvg, 0.0, 0.0);
            uGraphicSvg.createXml(outputStream);
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps uGraphicEps = new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            ganttDiagram.draw(uGraphicEps, 0.0, 0.0);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            UGraphicEps uGraphicEps = new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            ganttDiagram.draw(uGraphicEps, 0.0, 0.0);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
        return new ImageDataSimple();
    }

    private BufferedImage createImage(GanttDiagram ganttDiagram) {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, this.background);
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(this.colorMapper, graphics2D, 1.0);
        double d = ganttDiagram.getHeight(uGraphicG2d.getStringBounder());
        double d2 = ganttDiagram.getWidth(uGraphicG2d.getStringBounder());
        graphics2D.dispose();
        emptyImageBuilder = new EmptyImageBuilder(d2, d, this.background);
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        graphics2D = emptyImageBuilder.getGraphics2D();
        uGraphicG2d = new UGraphicG2d(this.colorMapper, graphics2D, 1.0);
        uGraphicG2d.setBufferedImage(bufferedImage);
        ganttDiagram.draw(uGraphicG2d, 0.0, 0.0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public final Project getProject() {
        return this.project;
    }
}

