/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.Project2;
import net.sourceforge.plantuml.project2.Row;
import net.sourceforge.plantuml.project2.RowSimple;
import net.sourceforge.plantuml.project2.RowUtils;
import net.sourceforge.plantuml.project2.Task;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GanttDiagram2 {
    private final Project2 project;
    private final double dayWith = 20.0;
    private final UFont font = new UFont("Serif", 0, 9);
    private final FontConfiguration fontConfig = FontConfiguration.blackBlueTrue(this.font);

    public GanttDiagram2(Project2 project2) {
        this.project = project2;
    }

    public void draw(UGraphic uGraphic, double d, double d2) {
        TextBlock textBlock = this.project.getTimeHeader(20.0);
        Row row = this.getMainRow();
        TextBlock textBlock2 = row.header();
        double d3 = textBlock2.calculateDimension(uGraphic.getStringBounder()).getWidth();
        double d4 = textBlock.calculateDimension(uGraphic.getStringBounder()).getHeight();
        textBlock2.drawU(uGraphic.apply(new UTranslate(d, d2 + d4)));
        TextBlock textBlock3 = row.asTextBloc(this.project.getTimeConverter(20.0));
        textBlock3.drawU(uGraphic.apply(new UTranslate(d + d3, d2 + d4)));
        textBlock.drawU(uGraphic.apply(new UTranslate(d + d3, d2)));
    }

    private Row getMainRow() {
        List<Task> list = this.project.getTasks();
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (Task task : list) {
            String string = task.getCode();
            TextBlock textBlock = Display.create(string).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            arrayList.add(new RowSimple((Day)task.getStart(), (Day)task.getEnd(), HtmlColorUtils.BLACK, TextBlockUtils.withMargin(textBlock, 3.0, 3.0)));
        }
        Row row = RowUtils.merge(arrayList);
        return row;
    }

    public double getWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.project.getTimeHeader(20.0);
        Row row = this.getMainRow();
        TextBlock textBlock2 = row.header();
        return textBlock2.calculateDimension(stringBounder).getWidth() + textBlock.calculateDimension(stringBounder).getWidth() + 1.0;
    }

    public double getHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.project.getTimeHeader(20.0);
        Row row = this.getMainRow();
        TextBlock textBlock2 = row.header();
        return textBlock2.calculateDimension(stringBounder).getHeight() + textBlock.calculateDimension(stringBounder).getHeight();
    }
}

