/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Skeleton2 {
    private final List<Entry> entries = new ArrayList<Entry>();
    private static final double sizeX = 8.0;

    public void add(int n, double d) {
        this.entries.add(new Entry(n, d));
    }

    public void draw(UGraphic uGraphic) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            entry.drawHline(uGraphic);
            Entry entry2 = this.getMotherOrSister(i);
            entry.drawVline(uGraphic, entry2 == null ? 0.0 : entry2.ypos);
        }
    }

    private Entry getMotherOrSister(int n) {
        int n2 = this.entries.get(n).level;
        for (int i = n - 1; i >= 0; --i) {
            int n3 = this.entries.get(i).level;
            if (n3 != n2 && n3 != n2 - 1) continue;
            return this.entries.get(i);
        }
        return null;
    }

    private static double getXStartForLevel(int n) {
        return (double)n * 8.0;
    }

    public double getXEndForLevel(int n) {
        return Skeleton2.getXStartForLevel(n) + 8.0;
    }

    static class Entry {
        private final int level;
        private final double ypos;

        Entry(int n, double d) {
            this.level = n;
            this.ypos = d;
        }

        void drawHline(UGraphic uGraphic) {
            double d = Skeleton2.getXStartForLevel(this.level);
            uGraphic.apply(new UTranslate(d + 8.0 - 1.0, this.ypos - 1.0)).draw(new URectangle(2.0, 2.0));
            uGraphic.apply(new UTranslate(d, this.ypos)).draw(new ULine(8.0, 0.0));
        }

        public void drawVline(UGraphic uGraphic, double d) {
            double d2 = Skeleton2.getXStartForLevel(this.level);
            uGraphic.apply(new UTranslate(d2, d)).draw(new ULine(0.0, this.ypos - d));
        }
    }
}

