/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Englober {
    private final ParticipantEnglober participantEnglober;
    private final List<Participant> participants = new ArrayList<Participant>();
    private final TileArguments tileArguments;
    private final Real core1;
    private final Real core2;

    @Deprecated
    public Englober(ParticipantEnglober participantEnglober, Participant participant, ISkinParam iSkinParam, Skin skin) {
        this(participantEnglober, participant, Englober.convertFunctionToBeRemoved(iSkinParam, skin));
    }

    private static TileArguments convertFunctionToBeRemoved(ISkinParam iSkinParam, Skin skin) {
        TileArguments tileArguments = new TileArguments(TextBlockUtils.getDummyStringBounder(), null, skin, iSkinParam, null);
        return tileArguments;
    }

    public Englober(ParticipantEnglober participantEnglober, Participant participant, TileArguments tileArguments) {
        if (tileArguments == null) {
            throw new IllegalArgumentException();
        }
        this.participantEnglober = participantEnglober;
        this.participants.add(participant);
        this.tileArguments = tileArguments;
        double d = this.getPreferredWidth();
        if (tileArguments.getLivingSpaces() == null) {
            this.core1 = null;
            this.core2 = null;
        } else {
            this.core1 = this.getMiddle().addFixed(-d / 2.0);
            this.core2 = this.getMiddle().addFixed(d / 2.0);
        }
    }

    public final Participant getFirst2TOBEPRIVATE() {
        return this.participants.get(0);
    }

    public final Participant getLast2TOBEPRIVATE() {
        return this.participants.get(this.participants.size() - 1);
    }

    private Real getMiddle() {
        return RealUtils.middle(this.getPosB(), this.getPosD());
    }

    private Real getPosB() {
        return this.getFirstLivingSpace().getPosB();
    }

    private Real getPosD() {
        return this.getLastLivingSpace().getPosD(this.tileArguments.getStringBounder());
    }

    private Real getPosAA() {
        LivingSpace livingSpace = this.tileArguments.getLivingSpaces().previous(this.getFirstLivingSpace());
        if (livingSpace == null) {
            return this.tileArguments.getOrigin();
        }
        return livingSpace.getPosD(this.tileArguments.getStringBounder());
    }

    private Real getPosZZ() {
        LivingSpace livingSpace = this.tileArguments.getLivingSpaces().next(this.getLastLivingSpace());
        if (livingSpace == null) {
            return null;
        }
        return livingSpace.getPosB();
    }

    private LivingSpace getFirstLivingSpace() {
        return this.tileArguments.getLivingSpace(this.getFirst2TOBEPRIVATE());
    }

    private LivingSpace getLastLivingSpace() {
        return this.tileArguments.getLivingSpace(this.getLast2TOBEPRIVATE());
    }

    private Component getComponent() {
        ParticipantEnglober participantEnglober = this.getParticipantEnglober();
        ISkinParam iSkinParam = participantEnglober.getBoxColor() == null ? this.tileArguments.getSkinParam() : new SkinParamBackcolored(this.tileArguments.getSkinParam(), participantEnglober.getBoxColor());
        return this.tileArguments.getSkin().createComponent(ComponentType.ENGLOBER, null, iSkinParam, participantEnglober.getTitle());
    }

    public final ParticipantEnglober getParticipantEnglober() {
        return this.participantEnglober;
    }

    public boolean contains(Participant participant) {
        return this.participants.contains(participant);
    }

    public void add(Participant participant) {
        if (this.participants.contains(participant)) {
            throw new IllegalArgumentException();
        }
        this.participants.add(participant);
    }

    public String toString() {
        return "ParticipantEngloberContexted:" + this.participantEnglober.getTitle().toString() + " " + this.participants;
    }

    private double getPreferredWidth() {
        return this.getComponent().getPreferredWidth(this.tileArguments.getStringBounder());
    }

    public double getPreferredHeight() {
        Component component = this.tileArguments.getSkin().createComponent(ComponentType.ENGLOBER, null, this.tileArguments.getSkinParam(), this.getParticipantEnglober().getTitle());
        return component.getPreferredHeight(this.tileArguments.getStringBounder());
    }

    public void drawEnglober(UGraphic uGraphic, double d, Context2D context2D) {
        double d2 = this.getX1().getCurrentValue() - 4.0;
        double d3 = this.getX2().getCurrentValue() + 4.0;
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d3 - d2, d);
        this.getComponent().drawU(uGraphic.apply(new UTranslate(d2, 1.0)), new Area(dimension2DDouble), context2D);
    }

    private Real getX2() {
        return RealUtils.max(this.getPosD(), this.core2);
    }

    private Real getX1() {
        return RealUtils.min(this.getPosB(), this.core1);
    }

    public void addInternalConstraints() {
        this.getX1().ensureBiggerThan(this.getPosAA().addFixed(10.0));
        Real real = this.getPosZZ();
        Real real2 = this.getX2().addFixed(10.0);
        if (real != null) {
            real.ensureBiggerThan(real2);
        }
    }

    public void addConstraintAfter(Englober englober) {
        englober.getX1().ensureBiggerThan(this.getX2().addFixed(10.0));
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getX1();
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.getX2().addFixed(10.0);
    }
}

