/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;

public class LifeEvent
extends AbstractEvent
implements Event {
    private final Participant p;
    private final LifeEventType type;
    private final SymbolContext backcolor;
    private AbstractMessage message;

    public LifeEvent(Participant participant, LifeEventType lifeEventType, SymbolContext symbolContext) {
        this.p = participant;
        this.type = lifeEventType;
        this.backcolor = symbolContext;
    }

    public String toString() {
        return "LifeEvent:" + this.p + " " + (Object)((Object)this.type);
    }

    public Participant getParticipant() {
        return this.p;
    }

    public LifeEventType getType() {
        return this.type;
    }

    public SymbolContext getSpecificColors() {
        return this.backcolor;
    }

    public boolean dealWith(Participant participant) {
        return this.p == participant;
    }

    public boolean isActivate() {
        return this.type == LifeEventType.ACTIVATE;
    }

    public boolean isDeactivateOrDestroy() {
        return this.type == LifeEventType.DEACTIVATE || this.type == LifeEventType.DESTROY;
    }

    @Deprecated
    public boolean isDestroy() {
        return this.type == LifeEventType.DESTROY;
    }

    public boolean isDestroy(Participant participant) {
        return this.p == participant && this.type == LifeEventType.DESTROY;
    }

    public void setMessage(AbstractMessage abstractMessage) {
        this.message = abstractMessage;
    }

    public AbstractMessage getMessage() {
        return this.message;
    }

    public void setLinkedToGroupingEnd(boolean bl) {
    }
}

