/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.text.DecimalFormat;
import java.util.List;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandAutonumber
extends SingleLineCommand<SequenceDiagram> {
    public CommandAutonumber() {
        super("(?i)^autonumber[%s]*(\\d+)?(?:[%s]+(\\d+))?(?:[%s]+[%g]([^%g]+)[%g])?[%s]*$");
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, List<String> list) {
        DecimalFormat decimalFormat;
        int n = 1;
        if (list.get(0) != null) {
            n = Integer.parseInt(list.get(0));
        }
        int n2 = 1;
        if (list.get(1) != null) {
            n2 = Integer.parseInt(list.get(1));
        }
        String string = list.get(2) == null ? "<b>0</b>" : list.get(2);
        try {
            decimalFormat = new DecimalFormat(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return CommandExecutionResult.error("Error in pattern : " + string);
        }
        sequenceDiagram.autonumberGo(n, n2, decimalFormat);
        return CommandExecutionResult.ok();
    }
}

